<?php
/**
 * Empty cart page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart-empty.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see        https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.5.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>
<div class="banner-wrapper-cart">
<?php
	get_template_part( 'partials/banner/banner-shop' );
?>
</div>
<?php

wc_print_notices();

?>

<div class="wrapper-empty-cart">
<div class="row">
	<div class="col-sm-12">
		<div class="empty-cart-message">
			<h3 class="cart-empty text-center text-capitalize"><?php esc_html_e( 'Your cart is currently empty!', 'inspiry-tourpress' ) ?></h3>
			<?php if ( wc_get_page_id( 'shop' ) > 0 ) : ?>
				<p class="return-to-shop text-center">
					<a class="btn" href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>">
						<?php esc_html_e( 'Return To Shop', 'inspiry-tourpress' ); ?>
					</a>
				</p>
			<?php endif; ?>
		</div>
	</div>
</div>
</div>


