<?php get_header(); ?>
<!-- blog detail page -->
<div id="content-wrapper" class="site-page blog-single <?php tourpress_content_width('sidebar-1'); ?>">
	<div class="container">
		<div class="row">
			<div class="col-md-8 col-main-content">
				<div class="blog-detail">
					<div class="row">
						<div class="col-lg-12">
							<?php
								// The Loop
								if ( have_posts() ) {
									while ( have_posts() ) {
										the_post();
										?>
										<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
											<?php
												if ( has_post_thumbnail() ) {
													?>
													<figure class="entry-thumbnail">
														<?php the_post_thumbnail(); ?>
													</figure>
													<?php
												}
											?>
											<div class="post-content entry-content">
												<div class="entry-meta-top">
													<span class="meta-item entry-category"><i class="fa fa-folder-open-o"></i> <?php the_category( ', ' ); ?></span>
													<?php
													printf( '<span class="meta-item entry-author"><i class="fa fa-user-o"></i> <a class="author-url" href="%1$s" rel="author">%2$s</a> </span>',
														esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
														get_the_author()
													);
													?>
												</div>
												<?php

													the_content();

													$link_pages_args = array(
														'before'   => '<nav class="navigation pagination"><div class="nav-links">',
														'after'    => '</div></nav>',
														'pagelink' => '<span>%</span>',
														'echo'     => 1
													);

													wp_link_pages( $link_pages_args );
												?>
												<div class="entry-meta">
													<span class="meta-item entry-date"><i class="fa fa-calendar-check-o"></i> <time datetime="<?php the_time( 'Y-m-d' ); ?>"><?php the_time( get_option( 'date_format' ) ); ?></time></span>
													<span class="meta-item entry-comments"><i class="fa fa-comment-o"></i><a href="<?php comments_link(); ?>"> <?php comments_number( esc_html__( 'No Comments', 'inspiry-tourpress' ), esc_html__( 'one Comment', 'inspiry-tourpress' ), esc_html__( 'Comments (%)', 'inspiry-tourpress' ) ); ?></a></span>
													<span class="meta-item entry-tags"><?php the_tags( '<i class="fa fa-tags" aria-hidden="true"></i>' ); ?></span>
												</div>
											</div>
										</article>
										<?php
									}
								}
							?>
							<div class="post-detail white-bg">
								<?php
									// related posts
									get_template_part( 'partials/blog/single/related', 'posts' );

									// post author
									get_template_part( 'partials/blog/single/post', 'author' );

									// If comments are open and there is at least one comment, load up the comment template.
									if ( comments_open() || get_comments_number() ) :
										comments_template();
									endif;
								?>
							</div>
						</div>
					</div>
				</div>
			</div>
            <?php get_sidebar(); ?>
		</div>
	</div>
</div>
<?php get_footer(); ?>