<?php get_header(); ?>
	<!-- blog detail page -->

<?php
$tourpress_content_width = 'tourpress-content-fullwidth';
$booking_form            = get_theme_mod( 'inspiry_booking_form', 'show' );
if ( is_active_sidebar( 'sidebar-tour-detail' ) || ( 'show' === $booking_form && is_singular( 'tour' ) ) ) {
	$tourpress_content_width = '';
}
?>

	<div id="content-wrapper" class="site-page tour-single <?php echo esc_attr( $tourpress_content_width ); ?>">
		<div class="container">
			<div class="row">
				<div class="col-md-8 col-main-content">
					<?php

						// The Loop
						if ( have_posts() ) {
							while ( have_posts() ) {
								the_post();

								$tour_meta = get_post_custom();

								$itinerary = $location = $photos = false;

								if ( isset( $tour_meta['inspiry_tour_itinerary_display'][0] ) && 'show' == $tour_meta['inspiry_tour_itinerary_display'][0] ) {
									// tour itinerary
									$tour_itinerary = rwmb_meta( 'inspiry_tour_itinerary' );

									if ( ! empty( $tour_itinerary ) && is_array( $tour_itinerary ) ) {
										$itinerary = true;
									}
								}

								if ( isset( $tour_meta['inspiry_tour_location_display'][0] ) && 'show' == $tour_meta['inspiry_tour_location_display'][0] ) {
									$location = true;
								}

								if ( isset( $tour_meta['inspiry_tour_gallery_display'][0] ) && 'show' == $tour_meta['inspiry_tour_gallery_display'][0] ) {
									if ( isset( $tour_meta['inspiry_tour_images'] ) && ! empty( $tour_meta['inspiry_tour_images'] ) ) {
										$photos = true;
									}
								}

								?>
								<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
									<ul class="tour-tabs clearfix">
										<li data-tab="tour-detail" class="active"><?php esc_html_e( 'Details', 'inspiry-tourpress' ); ?></li>
										<?php

											if ( $itinerary ) {
												?>
												<li data-tab="tour-itinerary"><?php esc_html_e( 'Itinerary', 'inspiry-tourpress' ); ?></li><?php
											}

											if ( $location ) {
												?>
												<li data-tab="tour-location"><?php esc_html_e( 'Location', 'inspiry-tourpress' ); ?></li><?php
											}

											if ( $photos ) {
												?>
												<li data-tab="tour-gallery"><?php esc_html_e( 'Photos', 'inspiry-tourpress' ); ?></li><?php
											}
										?>
									</ul>

									<div class="post-content entry-content">
										<?php
											get_template_part( 'partials/tour/content-detail' );

											if ( $itinerary ) {
												get_template_part( 'partials/tour/content-itinerary' );
											}

											if ( $location ) {
												get_template_part( 'partials/tour/content-location' );
											}

											if ( $photos ) {
												get_template_part( 'partials/tour/content-gallery' );
											}
										?>
									</div>
								</article>
								<?php
								$tours_reviews = get_theme_mod( 'inspiry_tours_reviews', 'show' );
								if ( 'show' == $tours_reviews ) {
									get_template_part( 'partials/tour/tour-reviews' );
								}
							}
						}
					?>
				</div>
                <?php get_sidebar( 'tour-detail' ); ?>
			</div>
			<?php
				$similar_tours = get_theme_mod( 'inspiry_similar_tours', 'show' );
				if ( 'show' == $similar_tours ) {
					?>
					<div class="row">
							<?php get_template_part( 'partials/tour/similar-tours' ); ?>
					</div>
					<?php
				}
			?>
		</div>
	</div>
<?php get_footer(); ?>