<?php
$sidebar         = get_theme_mod( 'inspiry_tax_archive_sidebar', 'disable' );
$tour_post_class = ( 'disable' == $sidebar ) ? ' tour-post-full-width' : '';
?>
<div class="tour-post clearfix<?php echo esc_attr( $tour_post_class ); ?>">
<?php

	// post custom meta data
	$tour_meta = get_post_custom();

?>
<figure>
	<?php

		echo '<a href="' . get_the_permalink() . '">';

		if ( has_post_thumbnail() ) {
			// tour featured image
			the_post_thumbnail( 'inspiry_image_size_720_560' );
		} else {
			echo '<img src="' . inspiry_image_placeholder( array( 720, 560 ), get_bloginfo( 'name' ), 120 ) . '" alt="' . esc_attr( get_bloginfo( 'name' ) ) . '" />';
		}
		echo '</a>';

		// tour meta icons list
		echo '<span class="tour-meta">';
		$tour_includes = inspiry_get_tour_meta();
		inspiry_icon( 'calendar', $tour_includes['months'], true );
		inspiry_icon( 'clock', $tour_includes['days'], true );
		inspiry_icon( 'flight', $tour_includes['departure'], true );
		inspiry_icon( 'location', $tour_includes['destination'], true );
		echo '</span>';

		if ( ! empty( $tour_meta['inspiry_tour_days'][0] ) ) {
			?>
			<div class="sunlight">
				<i class="fa fa-sun-o" aria-hidden="true"></i>
				<span class="tour-days"><?php echo esc_html( $tour_meta['inspiry_tour_days'][0] ); ?>
					<i><?php esc_html_e( 'days', 'inspiry-tourpress' ); ?></i></span>
			</div>
			<?php
		}
	?>
</figure>

<div class="offer-content">
	<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
	<?php 
	$tours_reviews = get_theme_mod( 'inspiry_tours_reviews', 'show' );
	if ( 'show' == $tours_reviews ) {
		inspiry_avg_rating_stars(); 
	} ?>
	<p>
		<?php
			$words_count = 15;

			if( is_page_template( 'page-templates/tours-list.php' ) ) {
				$words_count = 23;
			}

            if( is_archive() && ( 'disable' == $sidebar ) && ( 'list' == get_theme_mod( 'inspiry_tax_archive_layout', 'list' ) ) ) {
                $words_count = 42;
            }

			echo wp_trim_words( get_the_content(), $words_count, '...' );
		?>
	</p>
	<?php

		if ( ! empty( inspiry_get_price() ) ) {

			if ( inspiry_has_price() && inspiry_has_price( true ) ) {

				$current_price = inspiry_get_price( false, true );
				$old_price     = inspiry_get_price( false );
				$difference    = ceil( ( ( $current_price * 100 ) / $old_price ) );
				$discount      = 100 - $difference;

				if ( ! empty( $discount ) && ! is_page_template( 'page-templates/tours-listing.php' ) ) {
					echo '<div class="discount-label">' . intval( $discount ) . '% <span>' . esc_html__( 'Discount', 'inspiry-tourpress' ) . '</span></div>';
				}
				echo '<span class="old-price">' . inspiry_get_price() . '</span>';
				echo '<span class="tour-price">' . inspiry_get_price( true, true ) . '</span>';

			} else {
				echo '<span class="tour-price">' . inspiry_get_price() . '</span>';
			}
		}
	?>
	<a href="<?php the_permalink(); ?>" class="read-more"><?php esc_html_e( 'View More', 'inspiry-tourpress' ); ?></a>
</div>
</div>