<?php
	// If comments are open and there is at least one comment, load up the comment template.
	if ( comments_open() || get_comments_number() ) {
		?>
		<div class="tour-review white-bg">
			<header>
				<?php
					$tour_reviews_title = get_theme_mod( 'inspiry_tour_reviews_title', esc_html__( 'Tours Reviews', 'inspiry-tourpress' ) );
					$tour_reviews_desc  = get_theme_mod( 'inspiry_tour_reviews_description' );

					if ( ! empty( $tour_reviews_title ) ) {
						echo '<h2>' . esc_html( $tour_reviews_title ) . '</h2>';
					}

					if ( ! empty( $tour_reviews_desc ) ) {
						echo '<p>' . esc_html( $tour_reviews_desc ) . '</p>';
					}
				?>
			</header>
			<div class="review-wrapper">
				<?php comments_template(); ?>
			</div>
		</div>
		<?php
	}
?>