<?php
	// WP_Query arguments
	$args = array(
		'post_type'      => 'tour',
		'paged'          => $paged,
		'post__not_in'   => array( get_the_ID() ),
		'posts_per_page' => 3,
		'meta_key'       => '_thumbnail_id',
		'compare'        => 'EXISTS'
	);

	$tax_query = array();


	/* Tour Type */
	$type_terms = get_the_terms( get_the_ID(), "tour-type" );
	if ( ! empty( $type_terms ) && is_array( $type_terms ) ) {
		$types_array = array();
		foreach ( $type_terms as $type_term ) {
			$types_array[] = $type_term->term_id;
		}
		$tax_query[] = array(
			'taxonomy' => 'tour-type',
			'field'    => 'id',
			'terms'    => $types_array
		);
	}

	/* Tour Destination */
	$destination_terms = get_the_terms( get_the_ID(), "tour-destination" );
	if ( ! empty( $destination_terms ) && is_array( $destination_terms ) ) {
		$statuses_array = array();
		foreach ( $destination_terms as $destination_term ) {
			$statuses_array[] = $destination_term->term_id;
		}
		$tax_query[] = array(
			'taxonomy' => 'tour-type',
			'field'    => 'id',
			'terms'    => $statuses_array
		);
	}

	$tax_count = count( $tax_query );
	if ( $tax_count > 1 ) {
		$tax_query['relation'] = 'OR';
	}

	if ( $tax_count > 0 ) {
		$args['tax_query'] = $tax_query;
	}

	// The Query
	$query = new WP_Query( $args );

	if ( $query->found_posts > 0 ) {
		?>
		<div class="similar-tours-wrap">
			<?php
				$heading     = get_theme_mod( 'inspiry_similar_tours_title', esc_html__( 'Similar Tours', 'inspiry-tourpress' ) );
				$description = get_theme_mod( 'inspiry_similar_tours_description' );

				if ( ! empty( $heading ) || ! empty( $description ) ) {
					?>
					<div class="col-md-12">
						<header>
							<?php
								if ( ! empty( $heading ) ) {
									echo '<h3>' . esc_html( $heading ) . '</h3>';
								}
								if ( ! empty( $description ) ) {
									echo '<p>' . esc_html( $description ) . '</p>';
								}
							?>
						</header>
					</div>
					<?php
				}
			?>
			<div class="similar-tours tours-listing">
				<?php

					// The Loop
					if ( $query->have_posts() ) {
						while ( $query->have_posts() ) {
							$query->the_post();
							?>
							<div class="col-md-4 col-sm-6">
								<?php get_template_part( 'partials/tour/tour' ); ?>
							</div>
							<?php
						}
					} else {
						inspiry_no_posts();
					}
				?>
			</div>
		</div>
		<?php
	}
?>
