<div id="tour-gallery" class="tour-gallery">
	<section>
		<ul class="gallery-images inspiry-popup clearfix">
			<?php

				$images_ids = get_post_meta( get_the_ID(), 'inspiry_tour_images' );
				$images     = array();

				foreach ( $images_ids as $image_id ) {
					$images[ $image_id ]['thumbnail'] = wp_get_attachment_image_url( $image_id, 'inspiry_image_size_440_312' );
					$images[ $image_id ]['full']      = wp_get_attachment_image_url( $image_id, 'full' );
				}

				if ( ! empty( $images ) ) {

					foreach ( $images as $image ) {
						?>
						<li>
							<img src="<?php echo esc_url( $image['thumbnail'] ); ?>" alt="<?php esc_attr_e( 'Gallery Thumbnail', 'inspiry-tourpress' ); ?>">
							<a href="<?php echo esc_url( $image['full'] ); ?>">
								<div class="overlay">
									<img src="<?php echo get_template_directory_uri() . '/img/tour-gallery-icon.png'; ?>" alt="<?php esc_attr_e( 'Gallery Icon', 'inspiry-tourpress' ); ?>">
								</div>
							</a>
						</li>
						<?php
					}
				}
			?>
		</ul>
	</section>
	<?php get_template_part( 'partials/tour/download-button' ); ?>
</div>