<div id="tour-detail" class="tour-detail active">
	<h3 class="detail-title"><?php esc_html_e( 'Tour overview', 'inspiry-tourpress' ); ?></h3>
	<?php

		the_content();

		/*
		 * Tour Includes
		 */
		$tour_includes = get_post_meta( $post->ID, 'inspiry_tour_included', true );

		if ( ! empty( $tour_includes ) && is_array( $tour_includes ) ) {
			?>
			<div class="tour-include">
				<h3 class="detail-title"><?php esc_html_e( 'Included', 'inspiry-tourpress' ); ?></h3>
				<ul class="clearfix">
					<?php
					foreach ( $tour_includes as $include ) {
						echo '<li><i class="fa fa-check" aria-hidden="true"></i>' . esc_html( $include ) . '</li>';
					}
					?>
				</ul>
			</div>
			<?php
		}

		/*
		 * Tour Excludes
		 */
		$tour_excludes = get_post_meta( $post->ID, 'inspiry_tour_not_included', true );

		if ( ! empty( $tour_excludes ) && is_array( $tour_excludes )  ) {
			?>
			<div class="tour-exclude">
				<h3 class="detail-title"><?php esc_html_e( 'Not Included', 'inspiry-tourpress' ); ?></h3>
				<ul class="clearfix">
					<?php

						foreach ( $tour_excludes as $exclude ) {
							echo '<li><i class="fa fa-times" aria-hidden="true"></i>' . esc_html( $exclude ) . '</li>';
						}

					?>
				</ul>
			</div>
			<?php
		}

		get_template_part( 'partials/tour/download-button' );

	?>
</div>