<!-- travel destinations -->
<section class="full-section no-bottom-padding">
	<div class="container-fluid">
		<div class="row">
			<?php
				$title       = get_theme_mod( 'inspiry_travel_destinations_title', esc_html__( 'Travel Destinations', 'inspiry-tourpress' ) );
				$description = get_theme_mod( 'inspiry_travel_destinations_description' );
				inspiry_section_heading( $title, $description );
			?>
			<div class="travel-destinations">
				<div class="clearfix">
					<?php

						$number_of_destination = get_theme_mod( 'inspiry_travel_destinations_num', 8 );

						$terms = get_terms( array(
							'taxonomy'     => 'tour-destination',
							'hide_empty'   => true,
							'meta_key'     => 'featured_image',
							'meta_compare' => 'EXISTS',
							'number'       => $number_of_destination
						) );

						// default column settings
						$count      = count( $terms );
						$columns    = $columns_alt = 'col-md-4';
						$counter    = $col_switch = 1;

						// updating layout columns based on the number of destinations
						if ( 1 == $count || 2 == $count ) {
							$columns = 'col-md-6';
						} else if ( 3 == $count || 6 == $count ) {
							$columns = 'col-md-4';
						} else if ( 4 == $count || 8 == $count ) {
							$columns = 'col-md-3';
						} else if ( 5 == $count ) {
							$columns     = 'col-md-4';
							$columns_alt = 'col-md-6';
							$col_switch  = 3;
						} else if ( 7 == $count ) {
							$columns     = 'col-md-3';
							$columns_alt = 'col-md-4';
							$col_switch  = 4;
						}

						foreach ( $terms as $term ) {

							//$country   = get_term_meta( $term->term_id, 'country', true );
							$low_temp  = get_term_meta( $term->term_id, 'low_temp', true );
							$high_temp = get_term_meta( $term->term_id, 'high_temp', true );
							$image_id  = get_term_meta( $term->term_id, 'featured_image', true );
							$image_src = wp_get_attachment_image_src( $image_id, 'inspiry_image_size_720_560', false );

							?>
							<div class="col-xs-12 col-sm-6 travel-destination no-padding <?php if ( $counter < $col_switch ) { echo esc_attr( $columns_alt ); } else { echo esc_attr( $columns ); } ?>">
								<figure>
									<img class="img-responsive" src="<?php echo esc_url( $image_src[0] ); ?>" alt="<?php echo esc_attr( $term->name ); ?>">
									<div class="overlay">
										<?php
											if ( ! empty( $low_temp ) && ! empty( $high_temp ) ) {
												?>
												<div class="temperature">
													<span class="label"><?php esc_html_e( 'Local Temperature', 'inspiry-tourpress' ); ?></span>
													<span class="degree"><?php echo absint( esc_html( $low_temp ) ); ?>
														<sup><?php echo esc_html_x( '0', 'Lowest Temperature Degree Symbol', 'inspiry-tourpress' ); ?></sup> / <?php echo absint( esc_html( $high_temp ) ); ?>
														<sup><?php echo esc_html_x( '0', 'Highest Temperature Degree Symbol', 'inspiry-tourpress' ); ?></sup></span>
												</div>
												<?php
											}
										?>
										<div class="location">
											<header>
												<?php
												/*
													if ( ! empty( $country ) ) {
														?>
														<span><?php echo esc_html( $country ); ?></span>
														<?php
													}
												*/
												?>
												<h2><a href="<?php echo get_term_link( $term->term_id ); ?>"><?php echo esc_html( $term->name ); ?></a></h2>
											</header>
											<div class="detail">
												<?php
													if ( ! empty( $term->description ) ) {
														?>
														<p class="hidden-md"><?php echo wp_trim_words( esc_html( $term->description ), 25 ); ?></p>
														<?php
													}
												?>
												<span class="label"><?php echo esc_html__( 'Packages in', 'inspiry-tourpress' ) . ' ';
														echo esc_html( $term->name ); ?></span>
												<span class="number"><?php echo absint( esc_html( $term->count ) ) ?></span>
											</div>
										</div>
									</div>
								</figure>
							</div>
							<?php
							$counter++;
						}
					?>
				</div>
			</div>
		</div>
	</div>
</section>