<!-- testimonials -->
<section class="home-section dark-bg">
	<div class="container">
		<div class="row">
			<div class="col-sm-12">
				<?php

					$title       = get_theme_mod( 'inspiry_testimonials_title', esc_html__( 'Kind words from our Customers', 'inspiry-tourpress' ) );
					$description = get_theme_mod( 'inspiry_testimonials_description' );
					inspiry_section_heading( $title, $description );
				?>
				<div class="home-testimonials">
					<div class="row">
						<?php

							$number_of_posts = get_theme_mod( 'inspiry_testimonials_posts', 2 );
							// WP_Query arguments
							$args = array(
								'post_type'      => 'testimonial',
								'posts_per_page' => $number_of_posts
							);

							// The Query
							$query = new WP_Query( $args );

							if ( $query->have_posts() ) {
								while ( $query->have_posts() ) :
									$query->the_post();
									$post_custom = get_post_custom();
									?>
									<div class="col-sm-6">
										<article class="testimonial">
											<?php
												if ( has_post_thumbnail() ) {
													?>
													<figure>
														<?php the_post_thumbnail( array( 100, 100 ) ); ?>
													</figure>
													<?php
												}
											?>
											<div class="testimonial-content">
												<h3 class="author-name"><?php the_title(); ?></h3>
												<?php
													if ( ! empty( $post_custom['inspiry_testimonial_author_desi'][0] ) ) {
														echo '<span class="designation">' . esc_html( $post_custom['inspiry_testimonial_author_desi'][0] ) . '</span>';
													}
												?>
												<?php
													the_content();
													inspiry_rating_stars( absint( esc_html( $post_custom['inspiry_testimonial_rating'][0] ) ) );
												?>
											</div>
										</article>
									</div>
									<?php
								endwhile;
							}
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>