<!-- special offers -->
<section class="home-section">
	<div class="container">
		<div class="row">
			<div class="col-sm-12">
				<?php

					$title       = get_theme_mod( 'inspiry_special_offers_title', esc_html__( 'Special Offers', 'inspiry-tourpress' ) );
					$description = get_theme_mod( 'inspiry_special_offers_description' );

					inspiry_section_heading( $title, $description );
				?>
				<div class="special-offers">
					<div class="row">
						<?php
							$number_of_posts = get_theme_mod( 'inspiry_special_offer_tours', 6 );
							$posts_query     = array(
								'post_type'      => 'tour',
								'posts_per_page' => $number_of_posts,
								'meta_key'       => '_thumbnail_id',
								'meta_compare'   => 'EXISTS',
								'meta_query' => array(
									array(
										'key' => 'inspiry_tour_price_dis',
										'compare' => 'EXISTS'
									)
								)
							);

							$tours      = new WP_Query( $posts_query );
							$post_count = 1;

							if ( $tours->have_posts() ) {
								while ( $tours->have_posts() ) :
									$tours->the_post();
									$tour_meta = get_post_custom();
									?>
									<div class="col-xs-10 col-sm-6 col-md-10 col-lg-6 col-xs-offset-1 col-md-offset-1 col-sm-offset-0 col-lg-offset-0">
										<div class="tour-offer clearfix">
											<a href="<?php the_permalink(); ?>">
												<figure>
													<?php

														// tour thumbnail image
														the_post_thumbnail( 'inspiry_image_size_526_406', array( 'class' => 'img-fluid' ) );

														// tour price
														if ( ! empty( inspiry_get_price() ) ) {

															if ( inspiry_has_price() && inspiry_has_price( true ) ) {

																$current_price = inspiry_get_price( false, true );
																$old_price     = inspiry_get_price( false );
																$difference    = ceil( ( ( $current_price * 100 ) / $old_price ) );
																$discount      = 100 - $difference;

																echo '<span class="offer-price"><i>' . inspiry_get_price() . '</i>' . inspiry_get_price( true, true ) . '</span>';

															} else {
																echo '<span class="offer-price">' . inspiry_get_price() . '</span>';
															}
														}

														// tour days
														if ( ! empty( $tour_meta['inspiry_tour_days'][0] ) ) {
															?>
															<span class="sunlight"><i class="fa fa-sun-o" aria-hidden="true"></i> <?php echo esc_html( $tour_meta['inspiry_tour_days'][0] ); ?></span>
															<?php
														}
													?>
												</figure>
											</a>
											<div class="offer-content">
												<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
												<?php
												$tours_reviews = get_theme_mod( 'inspiry_tours_reviews', 'show' ); 
												if ( 'show' == $tours_reviews ) {
													inspiry_avg_rating_stars(); 
												}
												?>
												<p><?php echo wp_trim_words( get_the_content(), 8, '...' ); ?></p>
												<?php

													// tour meta icons list
													echo '<span class="tour-meta">';
													$tour_includes = inspiry_get_tour_meta();
													inspiry_icon( 'calendar', $tour_includes['months'], true );
													inspiry_icon( 'clock', $tour_includes['days'], true );
													inspiry_icon( 'flight', $tour_includes['departure'], true );
													inspiry_icon( 'location', $tour_includes['destination'], true );
													echo '</span>';
												?>
												<a href="<?php the_permalink(); ?>" class="read-more"><?php esc_html_e( 'more', 'inspiry-tourpress' ); ?></a>
											</div>
										</div>
									</div>
									<?php
									if ( $post_count % 2 == 0 ) {
										?>
										<div class="clearfix"></div><?php
									}
									$post_count ++;

								endwhile;
							}
						?>
					</div>
				</div><!--end .special-offers-->
			</div><!--end .col-sm-12-->
		</div><!--end .row-->
	</div><!--end .container-->
</section>