<?php

$slider_display = get_theme_mod( 'inspiry_home_slider_display', 'slider' );

if ( 'slider-revolution' == $slider_display ) {

	$rev_slider_alias = trim( get_theme_mod( 'inspiry_home_rs_alias' ) );
	if ( function_exists( 'putRevSlider' ) && ( ! empty( $rev_slider_alias ) ) ) {
		putRevSlider( $rev_slider_alias );
	} else {
		// page banner
		get_template_part( 'partials/header/banner' );
	}

} else {
	$slider_slides = get_theme_mod( 'inspiry_home_slider_slides', 3 );

	$query_args = array(
		'post_type'      => 'tour',
		'posts_per_page' => ( intval( $slider_slides ) + 1 ),
		'meta_key'       => 'inspiry_tour_in_slider',
		'meta_value'     => '1',
		'meta_compare'   => '='
	);

	$query = new WP_Query( $query_args );
	if ( $query->have_posts() && $slider_display == 'slider' ) {
		?>
		<div class="flexslider home-slider loading">
			<ul class="slides">
				<?php
					while ( $query->have_posts() ) {

						$query->the_post();
						$tour_meta = get_post_custom();
						$img_src   = '';

						//Returns Array of Term Names for "destination"
						$term_list = wp_get_post_terms( get_the_ID(), 'tour-destination', array( 'fields' => 'names' ) );

						if ( ! empty( $tour_meta['inspiry_tour_slider_image'][0] ) ) {
							$img_src = wp_get_attachment_image_src( $tour_meta['inspiry_tour_slider_image'][0], 'full' );
						}

						?>
						<li class="slide">
							<div>
								<?php
									if ( ! empty( $img_src ) ) {
										?><img src="<?php echo esc_url( $img_src[0] ); ?>" alt="<?php esc_attr_e( 'slide', 'inspiry-tourpress' ) ?>" /><?php
									}
								?>
								<header class="hidden-xs">
									<?php
										if ( ! empty( $tour_meta['inspiry_tour_smart_title'][0] ) ) {
											echo '<span>' . esc_html( $tour_meta['inspiry_tour_smart_title'][0] ) . '</span>';
										}
									?>
									<h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
									<?php
										if ( ! empty( $tour_meta['inspiry_tour_slide_description'][0] ) ) {
											echo '<p>' . esc_html( $tour_meta['inspiry_tour_slide_description'][0] ) . '</p>';
										}
									?>
								</header>

								<div class="detail visible-lg">
									<?php

										if ( ! empty( $term_list[0] ) ) {
											?>
											<div class="location cleafix">
												<?php include get_theme_file_path( '/img/svg/pin.svg' ); ?>
												<span><?php echo esc_html( $term_list[0] ); ?></span>
											</div>
											<?php
										}

										if ( ! empty( $tour_meta['inspiry_tour_days'][0] ) ) {
											?>
											<div class="days clearfix">
												<?php
													include get_theme_file_path( '/img/svg/sun.svg' );
													echo esc_html( $tour_meta['inspiry_tour_days'][0] );
												?>
												<span><?php esc_html_e( 'days', 'inspiry-tourpress' ); ?></span>
											</div>
											<?php
										}
									?>
									<div class="price clearfix">
										<span class="figure"><?php inspiry_price( true, true ); ?></span>
										<a href="<?php the_permalink(); ?>">
                        <span class="arrow">
                            <img class="img-fluid" src="<?php echo get_template_directory_uri(); ?>/img/slider/arrow.png" alt="<?php esc_attr_e( 'arrow', 'inspiry-tourpress' ); ?>">
                        </span>
										</a>
									</div>
								</div>

							</div>
						</li>
						<?php
					}
				?>
			</ul>
		</div>
		<?php

		get_template_part( 'partials/home/search-form' );

	} else {
		// page banner
		get_template_part( 'partials/header/banner' );
	}
}
?>
