<!-- destination by mood -->
<section class="home-section sky-bg" style="
<?php

	$background_url      = inspiry_filter_protocol( get_theme_mod( 'inspiry_md_background_image_url' ) );
	$background_repeat   = get_theme_mod( 'inspiry_md_background_repeat', 'no-repeat' );
	$background_size     = get_theme_mod( 'inspiry_md_background_size', 'auto' );
	$background_position = get_theme_mod( 'inspiry_md_background_position', 'center-center' );
	$background_color    = get_theme_mod( 'inspiry_md_background_color', '#DFF6FF' );

	if ( $background_url ) {
		echo 'background-image: url(' . esc_url( $background_url ) . '); ';
	}

	if ( $background_repeat ) {
		echo 'background-repeat: ' . esc_html( $background_repeat ) . '; ';
	}

	if ( $background_size ) {
		echo 'background-size: ' . esc_html( $background_size ) . '; ';
	}

	if ( $background_position ) {
		echo 'background-position: ' . str_replace( '-', ' ', esc_html( $background_position ) ) . '; ';
	}

	if ( $background_color ) {
		echo 'background-color: ' . esc_html( $background_color ) . '; ';
	}
?>
	">
	<div class="container">
		<div class="row">
			<div class="col-sm-12">
				<?php

					$title       = get_theme_mod( 'inspiry_mood_destinations_title', esc_html__( 'Select your Destination by Mood', 'inspiry-tourpress' ) );
					$description = get_theme_mod( 'inspiry_mood_destinations_description' );

					inspiry_section_heading( $title, $description );
				?>
				<div class="home-mood-destination">
					<div class="row">

						<?php

							$terms = get_terms( array(
								'taxonomy'   => 'tour-type',
								'hide_empty' => true,
								'number' => 6
							) );

							foreach ( $terms as $term ) {

								$icon_id   = get_term_meta( $term->term_id, 'type_icon', true );
								$image_id  = get_term_meta( $term->term_id, 'featured_image', true );
								$icon_src  = wp_get_attachment_image_src( $icon_id, 'full', false );
								$image_src = wp_get_attachment_image_src( $image_id, 'inspiry_image_size_330_404', false );
								$term_url  = get_term_link( $term );

								if ( ! empty ( $image_src [0] ) ) {
									?>
									<div class="col-xs-6 col-sm-3 col-md-2">
										<a href="<?php echo esc_url( $term_url ); ?>">
											<figure>
												<img src="<?php echo esc_url( $image_src[0] ); ?>" alt="<?php echo esc_attr( $term->name ); ?>">
												<div class="overlay">
													<?php
														if ( ! empty ( $icon_src ) ) {
															?>
															<img src="<?php echo esc_url( $icon_src[0] ); ?>" alt="<?php echo esc_attr( $term->name ); ?>">
															<?php
														}
													?>
													<span><?php echo esc_html( $term->name ); ?></span>
												</div>
											</figure>
										</a>
									</div>
									<?php
								}
							}
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>