<!-- features -->
<section class="home-section home-section-features">
	<div class="container">
		<div class="row">
			<div class="col-sm-12">
				<?php

					// to reset any query data being setup in any section above features section
					wp_reset_postdata();

					$title       = get_post_meta( get_the_ID(), 'Inspiry_Tours_features_title', true );
					$description = get_post_meta( get_the_ID(), 'Inspiry_Tours_features_description', true );

					inspiry_section_heading( $title, $description );

				?>
				<div class="home-features">
					<div class="row">
						<?php

							$features = get_post_meta( get_the_ID(), 'features', true );

							if ( ! empty( $features ) && is_array( $features ) ) {
								foreach ( $features as $feature ) {

									$feature_icon = ( isset( $feature['Inspiry_Tours_icon'][0] ) ? wp_get_attachment_image_url( $feature['Inspiry_Tours_icon'][0] ): null );
									$feature_title = ( isset( $feature['Inspiry_Tours_title'] ) ? $feature['Inspiry_Tours_title']: null  );
									$feature_description = ( isset( $feature['Inspiry_Tours_description'] ) ? $feature['Inspiry_Tours_description']: null );
									$feature_url = ( isset( $feature['Inspiry_Tours_url'] ) ? $feature['Inspiry_Tours_url']: null );
									?>
									<div class="col-sm-6 col-md-4">
										<div class="home-feature">
											<?php if ( ! empty( $feature_icon ) && ! empty( $feature_url ) ) { ?>
												<figure>
													<a href="<?php echo esc_url( $feature_url ) ?>"> 
														<img src="<?php echo esc_url( $feature_icon ) ?>" alt="<?php esc_attr_e( 'icon', 'inspiry-tourpress' ); ?>">
													</a>
												</figure>
											<?php } elseif ( ! empty( $feature_icon ) ) { ?> 
												<figure>
													<img src="<?php echo esc_url( $feature_icon ) ?>" alt="<?php esc_attr_e( 'icon', 'inspiry-tourpress' ); ?>">
												</figure>
											<?php }

												if ( ! empty( $feature_title ) && ! empty( $feature_url ) ) {
													echo '<a href="' . esc_url( $feature_url ) . '"><h3>' . esc_html( $feature_title ) . '</h3></a>';
												} elseif ( ! empty( $feature_title ) ) {
													echo '<h3>' . esc_html( $feature_title ) . '</h3>';
												}

												echo ( ! empty( $feature_description ) ) ? '<p>' . esc_html( $feature_description ) . '</p>' : '';
											?>
										</div>
									</div>
									<?php
								}
							}
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>