<!-- featured packages -->
<section class="home-section dark-bg">
	<div class="container">
		<div class="row">
			<div class="col-sm-12">
				<?php
					$title       = get_theme_mod( 'inspiry_featured_pack_title', esc_html__( 'Featured Packages', 'inspiry-tourpress' ) );
					$description = get_theme_mod( 'inspiry_featured_pack_description' );

					// section heading
					inspiry_section_heading( $title, $description );
				?>
				<div id="featured-packages" class="tours-listing owl-carousel owl-theme">
					<?php

						$number_of_posts = get_theme_mod( 'inspiry_featured_pack_tours', 3 );

						// posts arguments
						$args = array(
							'post_type'      => 'tour',
							'posts_per_page' => $number_of_posts,
							'meta_query'     => array(
								'relation' => 'AND',
								array(
									'key'     => 'inspiry_tour_featured',
									'value'   => '1',
									'compare' => '='
								),
								array(
									'key'     => '_thumbnail_id',
									'compare' => 'EXISTS'
								)
							)
						);

						// the query
						$query = new WP_Query( $args );

						// the loop
						if ( $query->have_posts() ) {
							while ( $query->have_posts() ) :
								$query->the_post();
								?>
								<div><?php get_template_part( 'partials/tour/tour' ) ?></div><?php
							endwhile;
						}
					?>
				</div>
			</div>
		</div>
	</div>
</section>