<!-- explore tours -->
<section class="full-section" style="
<?php

	$background_url      = inspiry_filter_protocol( get_theme_mod( 'inspiry_et_background_image_url' ) );
	$background_repeat   = get_theme_mod( 'inspiry_et_background_repeat', 'no-repeat' );
	$background_size     = get_theme_mod( 'inspiry_et_background_size', 'auto' );
	$background_position = get_theme_mod( 'inspiry_et_background_position', 'center-center' );

	if ( $background_url ) {
		echo 'background: url(' . esc_url( $background_url ) . '); ';
	}

	if ( $background_repeat ) {
		echo 'background-repeat: ' . esc_html( $background_repeat ) . '; ';
	}

	if ( $background_size ) {
		echo 'background-size: ' . esc_html( $background_size ) . '; ';
	}

	if ( $background_position ) {
		echo 'background-position: ' . str_replace( '-', ' ', esc_html( $background_position ) ) . '; ';
	}

?>
	">
	<div class="explore-tours">
		<div class="clearfix">
			<div class="col-sm-6"></div>
			<div class="col-sm-6">
				<div class="content">
					<?php

						$heading     = get_theme_mod( 'inspiry_explore_tours_title' );
						$description = get_theme_mod( 'inspiry_explore_tours_description' );
						$btn         = get_theme_mod( 'inspiry_explore_tours_btn' );
						$btn_url     = get_theme_mod( 'inspiry_explore_tours_url' );

						if ( ! empty( $heading ) ) {
							echo '<h2>' . esc_html( $heading ) . '</h2>';
						}

						if ( ! empty( $description ) ) {
							echo '<p>' . esc_html( $description ) . '</p>';
						}

						if ( ! empty( $btn ) && ! empty( $btn_url ) ) {
							echo '<a href="' . esc_url( $btn_url ) . '" class="read-more">' . esc_html( $btn ) . '</a>';
						}
					?>
				</div>
			</div>
		</div>
	</div>
</section>