<!-- blog -->
<section class="home-section">
	<div class="container">
		<div class="row">
			<div class="col-sm-12">
				<?php
					$title       = get_theme_mod( 'inspiry_news_title', esc_html__( 'Recent from Blog', 'inspiry-tourpress' ) );
					$description = get_theme_mod( 'inspiry_news_description' );

					// section heading
					inspiry_section_heading( $title, $description );
				?>
				<div class="blog-posts">
					<div class="row">
						<?php

							$number_of_posts = get_theme_mod( 'inspiry_news_posts_number', 3 );
							$posts_type      = get_theme_mod( 'inspiry_news_posts_type', 'recent' );

							// WP_Query arguments
							$args = array(
								'post_type'           => 'post',
								'posts_per_page'      => $number_of_posts,
								'ignore_sticky_posts' => true,
								'meta_query'          => array(
									'relation' => 'AND',
									array(
										'key'     => '_thumbnail_id',
										'compare' => 'EXISTS'
									)
								)
							);

							// arguments from categories and tags
							if ( 'random' === $posts_type ) {
								$args['orderby'] = 'rand';
							} elseif ( 'taxonomy' === $posts_type ) {
								$categories = get_theme_mod( 'inspiry_home_news_categories' );
								$tags       = get_theme_mod( 'inspiry_home_news_tags' );

								if ( ! empty( $categories ) ) {
									$args['category__in'] = explode( ',', $categories );
								}

								if ( ! empty( $tags ) ) {
									$args['tag__in'] = explode( ',', $tags );
								}
							}

							// The Query
							$query = new WP_Query( $args );

							// The Loop
							if ( $query->have_posts() ) {

								$count = 1;

								while ( $query->have_posts() ) {
									$query->the_post();
									?>
									<div class="col-sm-6 col-md-4">
										<?php get_template_part( 'partials/blog/post' ); ?>
									</div>
									<?php

									if ( $count % 2 == 0 ) {
										echo '<div class="clearfix visible-sm"></div>';
									}

									$count ++;
								}
							} else {
								// no posts found
								inspiry_no_posts();
							}
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>