<div class="tour-meta-bar">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<div class="tour-tags clearfix">
				<?php 
					$tours_reviews = get_theme_mod( 'inspiry_tours_reviews', 'show' ); 
					if ( 'show' == $tours_reviews ) { ?>
					<div class="tag-review">
						<?php
							$reviews_count = get_post_meta( get_the_ID(), 'inspiry_tour_reviews_count', true );

							if ( empty( $reviews_count ) ) {
								$reviews_count = 0;
							}

							$tours_reviews = get_theme_mod( 'inspiry_tours_reviews', 'show' ); 
							if ( 'show' == $tours_reviews ) {
								inspiry_avg_rating_stars(); 
							}
							echo '<a id="reviews-hash" href="#respond">';
							echo '(' . esc_html( $reviews_count ) . ' ' . esc_html__( 'Reviews', 'inspiry-tourpress' ) . ')';
							echo '</a>';
						?>
					</div>
				<?php } ?>
					<div class="tag-price">
						<?php
							include get_theme_file_path( '/img/svg/tag.svg' );

							$postfix = $postfix_html = inspiry_get_price_postfix();
							if ( ! empty( $postfix ) ) {
								$postfix_html = ' / ';
								$postfix_html .= '<span>' . esc_html( $postfix ) . '</span>';
							}
						?>
						<span>
						<?php
							inspiry_price( true, true );
							echo wp_kses( $postfix_html, array( array( 'span' ) ) );
						?>
						</span>
					</div>
				</div>

				<ul class="clearfix">
					<?php

						$tour_includes = inspiry_get_tour_meta();

						if( ! empty( $tour_includes['months'] ) ) {
							echo '<li>';
							inspiry_icon( 'calendar' );
							echo '<span class="tour-meta">' . esc_html( $tour_includes['months'] ) . '</span></li>';
						}

						if( ! empty( $tour_includes['days'] ) ) {
							echo '<li>';
							inspiry_icon( 'clock' );
							echo '<span class="tour-meta">' . esc_html( $tour_includes['days'] ) . '</span></li>';
						}

						if( ! empty( $tour_includes['departure'] ) ) {
							echo '<li>';
							inspiry_icon( 'flight' );
							echo '<span class="tour-meta">' . esc_html( $tour_includes['departure'] ) . '</span></li>';
						}

						if( ! empty( $tour_includes['destination'] ) ) {
							echo '<li>';
							inspiry_icon( 'location' );
							echo '<span class="tour-meta">' . esc_html( $tour_includes['destination'] ) . '</span></li>';
						}

						if( ! empty( $tour_includes['age'] ) ) {
							echo '<li>';
							inspiry_icon( 'user' );
							echo '<span class="tour-meta">' . esc_html( $tour_includes['age'] ) . '</span></li>';
						}

						if( ! empty( $tour_includes['members'] ) ) {
							echo '<li>';
							inspiry_icon( 'group' );
							echo '<span class="tour-meta">' . esc_html( $tour_includes['members'] ) . '</span></li>';
						}

						if( ! empty( $tour_includes['accommodation'] ) ) {
							echo '<li>';
							inspiry_icon( 'bed' );
							echo '<span class="tour-meta">' . esc_html( $tour_includes['accommodation'] ) . '</span></li>';
						}

						if( ! empty( $tour_includes['meal'] ) ) {
							echo '<li>';
							inspiry_icon( 'fast-food' );
							echo '<span class="tour-meta">' . esc_html( $tour_includes['meal'] ) . '</span></li>';
						}
					?>
				</ul>
			</div>
		</div>
	</div>
</div>