<div class="top-bar">
<div class="container">
	<div class="row">
		<div class="col-md-6">
			<?php

				$display_choice = get_theme_mod( 'inspiry_header_topbar_left_slot', 'note' );
				$note           = get_theme_mod( 'inspiry_topbar_note' );

				if ( 'note' === $display_choice && ! empty( $note ) ) {
					echo '<p class="welcome-note">' . esc_html( $note ) . '</p>';
				} elseif ( 'menu' === $display_choice ) {
					$primary_menu = array(
						'menu'           	=> 'Topbar Menu',
						'theme_location' 	=> 'topbar-menu',
						'menu_class'     	=> 'topber-menu clearfix',
						'container'      	=> 'nav',
						'fallback_cb'		=> false,
					);

					wp_nav_menu( $primary_menu );
				}
			?>
		</div>
		<div class="col-md-6">
			<?php

				$header_social['twitter']   = get_theme_mod( 'inspiry_topbar_twitter' );
				$header_social['facebook']  = get_theme_mod( 'inspiry_topbar_facebook' );
				$header_social['google']    = get_theme_mod( 'inspiry_topbar_google' );
				$header_social['youtube']   = get_theme_mod( 'inspiry_topbar_youtube' );
				$header_social['instagram'] = get_theme_mod( 'inspiry_topbar_instagram' );

				// woocommerce cart icon setup
				$woo_icon = get_theme_mod( 'inspiry_topbar_woo_icon', 'show' );
				if ( is_woocommerce_activated() && 'show' == $woo_icon ) {
					$items_count = WC()->cart->get_cart_contents_count();
					$shop_icon   = true;
					$has_icon    = 'has_item';
				} else {
					$shop_icon   = false;
					$has_icon    = '';
					$items_count = 0;
				}

				if ( isset( $header_social ) || ! empty( $header_social ) ) {
					echo '<ul class="smart-social ' . $has_icon . '">';

					// topbar social profiles
					do_action( 'inspiry_topbar_social_profiles', $header_social );

					if ( $shop_icon ) {
						?>
						<li class="shopping-cart">

							<?php
								include get_theme_file_path( '/img/svg/shopping-cart.svg' );
								if ( $items_count > 0 ) {
									?><span class="active-cart"></span><?php
								}
							?>
						</li>
						<?php
					}
					echo '</ul>';

					if ( $shop_icon ) {
						?>
						<div class="mini-cart-wrap">
							<div class="widget_shopping_cart_content">
								<?php echo wc_get_template( 'cart/mini-cart.php' ); ?>
							</div>
						</div>
						<?php
					}

				}

				$topbar_email = get_theme_mod( 'inspiry_topbar_email' );

				if ( ! empty( $topbar_email ) ) {
					?>
					<div class="header-email-wrap">
						<a href="mailto:<?php echo antispambot( sanitize_email( $topbar_email ) ); ?>" class="header-email"><i class="fa fa-envelope-o" aria-hidden="true"></i> <?php echo antispambot( sanitize_email( $topbar_email ) ); ?>
						</a>
					</div>
					<?php
				}
			?>
		</div>
	</div>
</div>
</div>