<?php
$banner_title         = null;
$banner_title_display = get_theme_mod( 'inspiry_banner_page_title', 'show' );
$bread_crumbs_display = get_theme_mod( 'inspiry_banner_bread_crumbs', 'show' );

if ( is_home() ) {

	$banner_title = inspiry_blog_title();

} elseif ( is_404() ) {

	$banner_title = esc_html__( 'Page 404', 'inspiry-tourpress' );

} elseif ( is_page() || is_front_page() || is_single() || is_singular( 'tour' ) ) {

	$banner_title = get_the_title();

} elseif ( is_search() ) {

	$banner_title = sprintf( esc_html__( 'Search Results for: %s', 'inspiry-tourpress' ), get_search_query() );

} elseif ( is_author() ) {

	global $wp_query;
	$current_author = $wp_query->get_queried_object();
	if ( ! empty( $current_author->display_name ) ) {
		$banner_title = $current_author->display_name;
	}

} elseif ( is_woocommerce_activated() && is_shop() ) {

	$banner_title = get_theme_mod( 'inspiry_shop_banner_title', esc_html__( 'Shop', 'inspiry-tourpress' ) );

} elseif ( is_archive() ) {
	$banner_title = get_the_archive_title();
}

$banner_title = apply_filters( 'inspiry_page_banner_tile', $banner_title );
$banner_image = inspiry_header_banner_image();
?>
<div id="site-banner"
	<?php
		if ( ! empty( $banner_image ) ) {
			echo 'style="' . $banner_image . '"';
		} else {
			echo 'class="no-banner-image"';
		}
	?>>
	<div class="banner-content">
		<?php

			if ( is_woocommerce_activated() && is_product() ) {
				echo '<h2>' . esc_html__( 'Shop', 'inspiry-tourpress' ) . '</h2>';
			} else if ( ! empty ( $banner_title ) && $banner_title_display == 'show' ) {
				echo '<h1>' . $banner_title . '</h1>';
			}

			if ( $bread_crumbs_display == 'show' ) {
				inspiry_breadcrumbs();
			}
		?>
	</div>
</div>
<?php
if ( is_singular( 'tour' ) ) {
	get_template_part( 'partials/header/tour-meta' );
}
?>