<?php
$meta_data = get_post_custom();

if ( 'show' === $meta_data['Inspiry_Tours_offices_display'][0] ) {
	?>
	<!--offices contact-->
	<section class="contact-section inspiry-box-shadow white-bg">
		<div class="offices-contact">

			<!--head office-->
			<?php

				if ( ! empty( $meta_data['Inspiry_Tours_office_head_title'][0] ) ) {
					echo '<h3>' . esc_html( $meta_data['Inspiry_Tours_office_head_title'][0] ) . '</h3>';
				}
			?>
			<div class="head-office clearfix">
				<div class="row">
					<?php
						if (
							! empty( $meta_data['Inspiry_Tours_office_location'][0] ) ||
							! empty( $meta_data['Inspiry_Tours_office_address'][0] ) ||
							! empty( $meta_data['Inspiry_Tours_office_number'][0] ) ||
							! empty( $meta_data['Inspiry_Tours_office_email'][0] )
						) {
							?>
							<div class="col-sm-6">
								<div class="office-contact">
									<?php

										// office location
										if ( ! empty( $meta_data['Inspiry_Tours_office_location'][0] ) ) {
											echo '<h4>' . esc_html( $meta_data['Inspiry_Tours_office_location'][0] ) . '</h4>';
										}

										// office address
										if ( ! empty( $meta_data['Inspiry_Tours_office_address'][0] ) ) {
											echo '<address>' . wp_kses( $meta_data['Inspiry_Tours_office_address'][0], wp_kses_allowed_html() ) . '</address>';
										}

										// office phone number
										if ( ! empty( $meta_data['Inspiry_Tours_office_number'][0] ) ) {
											?>
											<div class="number">
												<?php
													include get_theme_file_path( '/img/svg/call.svg' );
													echo '<span>' . esc_html( $meta_data['Inspiry_Tours_office_number'][0] ) . '</span>';
												?>
											</div>
											<?php
										}

										// office email
										if ( ! empty( $meta_data['Inspiry_Tours_office_email'][0] ) ) {
											?>
											<div class="email">
												<i class="fa fa-envelope-o" aria-hidden="true"></i>
												<?php echo '<a href="mailto:' . antispambot( sanitize_email( $meta_data['Inspiry_Tours_office_email'][0] ) ) . '">' . antispambot( sanitize_email( $meta_data['Inspiry_Tours_office_email'][0] ) ) . '</a>'; ?>
											</div>
											<?php
										}
									?>
								</div>
							</div>
							<?php
						}
					?>
					<div class="col-sm-6">
						<?php
							if ( ! empty( $meta_data['Inspiry_Tours_working_days'][0] ) ) {
								?>
								<div class="office-timing">
									<h4><?php esc_html_e( 'Opening Times:', 'inspiry-tourpress' ); ?></h4>
									<p class="open">
										<?php

											echo esc_html( $meta_data['Inspiry_Tours_working_days'][0] );

											if ( ! empty( $meta_data['Inspiry_Tours_working_time'][0] ) ) {
												echo '<span>' . esc_html( $meta_data['Inspiry_Tours_working_time'][0] ) . '</span>';
											}
										?>
									</p>
									<?php

										if ( ! empty( $meta_data['Inspiry_Tours_working_off'][0] ) ) {

											echo '<p class="closed">' . esc_html( $meta_data['Inspiry_Tours_working_off'][0] );

											if ( ! empty( $meta_data['Inspiry_Tours_working_off_label'][0] ) ) {
												echo '<span>' . esc_html( $meta_data['Inspiry_Tours_working_off_label'][0] ) . '</span>';
											}

											echo '</p>';
										}
									?>
								</div>
								<?php
							}
						?>
					</div>
				</div>
			</div>

			<!--branch office-->
			<?php

				// branch offices
				$branch_offices = rwmb_meta( 'branch_offices' );
				if ( ! empty( $branch_offices ) ) {

					if ( ! empty( $meta_data['Inspiry_Tours_office_branch_title'][0] ) ) {
						echo '<h3 class="branches-heading">' . esc_html( $meta_data['Inspiry_Tours_office_branch_title'][0] ) . '</h3>';
					}

					echo '<div class="branch-office clearfix"><div class="row">';

					$count = 1;

					foreach ( $branch_offices as $office ) {
						?>
						<div class="bch-office col-sm-6">
							<div class="office-contact">
								<?php

								// office location
								if ( ! empty( $office['Inspiry_Tours_office_br_location'] ) ) {
									echo '<h4>' . esc_html( $office['Inspiry_Tours_office_br_location'] ) . '</h4>';
								}

								// office address
								if ( ! empty( $office['Inspiry_Tours_office_br_address'] ) ) {
									echo '<address>' . wp_kses( $office['Inspiry_Tours_office_br_address'], wp_kses_allowed_html() ) . '</address>';
								}

								// office phone number
								if ( ! empty( $office['Inspiry_Tours_office_br_number'] ) ) {
									?>
									<div class="number">
										<?php
											include get_theme_file_path( '/img/svg/call.svg' );
											echo '<span>' . esc_html( $office['Inspiry_Tours_office_br_number'] ) . '</span>';
										?>
									</div>
									<?php
								}

								// office email
								if ( ! empty( $office['Inspiry_Tours_office_br_email'] ) ) {
									?>
									<div class="email">
										<i class="fa fa-envelope-o" aria-hidden="true"></i>
										<?php echo '<a href="mailto:' . antispambot( sanitize_email( $office['Inspiry_Tours_office_br_email'] ) ) . '">' . antispambot( sanitize_email( $office['Inspiry_Tours_office_br_email'] ) ) . '</a>'; ?>
									</div>
									<?php
								}
								?>
							</div>
						</div>
						<?php
							if ( $count % 2 == 0 ) {
								?><div class="clearfix"></div><?php
							}
							$count++;
						?>
						<?php
					}

					echo '</div></div>';
				}
			?>
		</div>
	</section>
	<?php
}
?>