<!--google map-->
<?php

	$meta_data = get_post_custom();

	if ( 'show' === $meta_data['Inspiry_Tours_map_display'][0] ) {
		?>
		<section class="contact-section inspiry-box-shadow map-wrap white-bg">
			<div class="google-map">
				<?php
					if ( ! empty( $meta_data['Inspiry_Tours_map_title'][0] ) ) {
						echo '<h3>' . esc_html( $meta_data['Inspiry_Tours_map_title'][0] ) . '</h3>';
					}

				?>
				<div id="contact-map">
					<?php
						$google_map_api_key = inspiry_get_google_map_api_key();

						if ( empty( $google_map_api_key ) ) {
							?>
							<p>
								<?php
									echo wp_kses( sprintf( __( 'Google Maps API Key is not set. You can add your Google Maps API Key under
										<strong>Easy Tours > Settings</strong> options panel. If you do not have one yet then
										create by <a href="%s" target="_blank">clicking here</a>.', 'inspiry-tourpress' ), 'https://developers.google.com/maps/documentation/javascript/get-api-key' ), wp_kses_allowed_html() );
								?>
							</p>
							<?php
						}
					?>
				</div>
			</div>
		</section>
		<?php
	}
?>