<section class="related-posts">
<?php
	if ( get_previous_post_link() || get_next_post_link() ) {
		?>
		<div class="in-navigation clearfix">
			<?php

				if ( get_previous_post_link() ) {
					?>
					<div class="post-nav col-xs-12 col-sm-6">
						<?php previous_post_link( '%link', esc_html__( 'Previous Post', 'inspiry-tourpress' ) ); ?>
						<div>
							<?php previous_post_link( '%link', '%title' ); ?>
						</div>
					</div>
					<?php
				}

				if ( get_next_post_link() ) {
					?>
					<div class="post-nav col-xs-12 col-sm-6">
						<?php next_post_link( '%link', esc_html__( 'Next Post', 'inspiry-tourpress' ) ); ?>
						<div>
							<?php next_post_link( '%link', '%title' ); ?>
						</div>
					</div>
					<?php
				}
			?>
		</div>
		<?php
	}

	$categories = get_the_category();
	$cat_slugs  = array();

	foreach ( $categories as $category ) {
		$cat_slugs[] = $category->slug;
	}

	$posts = get_posts( array(
		'posts_per_page' => 2,
		'post__not_in'   => array( get_the_ID() ),
		'tax_query'      => array(
			array(
				'taxonomy' => 'category',
				'field'    => 'slug',
				'terms'    => $cat_slugs,
			),
		)
	) );

	if ( $posts ) {
		?>
		<h2 class="title"><?php esc_html_e( 'Related Posts', 'inspiry-tourpress' ); ?></h2>
		<div class="in-category clearfix">
			<?php
				foreach ( $posts as $post ) {
					setup_postdata( $post );
					?>
					<div class="related-post col-xs-12 col-sm-6">
						<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
						<span>
                        <?php
                            esc_html_e( 'IN', 'inspiry-tourpress' );
	                        echo inspiry_get_first_category( get_the_ID() );
                        ?>
                        </span>
					</div>
					<?php
				}

				wp_reset_postdata();
			?>
		</div>
		<?php
	}
?>
</section>