<!--post author -->
<?php

$author_meta = get_user_meta( get_the_author_meta( 'ID' ) );

if ( ! empty( $author_meta['description'][0] ) ) {

	?>
	<section class="post-author">
		<h2><?php esc_html_e( 'Written by Author', 'inspiry-tourpress' ); ?></h2>
		<div class="author clearfix">
			<figure>
				<?php echo get_avatar( get_the_author_meta( 'ID' ), 121 ); ?>
			</figure>
			<div class="author-detail">
				<ul class="smart-social">
					<?php
						// post author social profiles
						do_action( 'inspiry_author_social_profiles', $author_meta );
					?>
				</ul>
				<h3 class="bypostauthor"><?php the_author(); ?></h3>
				<p><?php echo esc_html( $author_meta['description'][0] ); ?></p>
				<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" class="view-all-btn" title="<?php esc_attr( the_author() ); ?>"><?php esc_html_e( 'view all posts by author', 'inspiry-tourpress' ); ?></a>
			</div>
		</div>
	</section>
<?php } ?>