<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<?php
		if ( has_post_thumbnail() ) {
			?>
			<figure class="blog-entry-thumbnail">
				<a href="<?php the_permalink(); ?>">
					<?php the_post_thumbnail( 'inspiry_image_size_720_560', array( 'class' => 'img-fluid' ) ); ?>
				</a>
			</figure>
			<?php
		}
	?>
	<div class="post-content">
		<h3 class="entry-title">
			<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
		</h3>
		<div class="blog-entry-meta">
			<span class="meta-item entry-date"><i class="fa fa-calendar-check-o"></i> <time datetime="<?php the_time( 'Y-m-d' ); ?>"><?php the_time( get_option( 'date_format' ) ); ?></time></span>
			<?php
				$first_category_link = inspiry_get_first_category( get_the_ID() );

				if( $first_category_link ) {
					?>
					<span class="meta-item entry-category"><i class="fa fa-folder-open-o"></i> <?php echo wp_kses_post( $first_category_link ); ?></span>
					<?php
				}
			?>
		</div>
		<p>
			<?php
				if ( ! post_password_required() ) {
					echo wp_trim_words( get_the_excerpt(), 9, '...' );
				} else {
					echo '<em>'. esc_html__( '[This is password-protected.]', 'inspiry-tourpress' ) .'</em>';
				}
			?>
		</p>
		<?php
			printf( '<span class="meta-item entry-author"><i class="fa fa-user-o"></i> <a class="author-url" href="%1$s" rel="author">%2$s</a> </span>',
				esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
				get_the_author()
			);
		?>
		<a href="<?php the_permalink(); ?>" class="read-more"><?php esc_html_e( 'more', 'inspiry-tourpress' ) ?></a>
	</div>
</article>