<?php
/**
 * Template Name: Tours Search
 */
get_header();

get_template_part( 'partials/home/search-form' );
?>
<!-- tours listing -->
<div id="content-wrapper" class="site-page tour-search">
	<div class="container">
		<div class="row">
			<div class="col-sm-12 col-main-content tours-grid-container">
				<div class="tours-listing">
					<div class="row">
						<?php
                            global $paged;
							// number of tours to display per page
						    $number_of_tours = get_theme_mod( 'inspiry_search_tours_per_page', '6' );
                        
							// WP_Query arguments
							$args = array(
								'post_type'      => 'tour',
								'paged'          => $paged,
								'posts_per_page' => intval( $number_of_tours )
							);

							// The Query
							$query = new WP_Query( apply_filters( 'inspiry_tours_search_args', $args ) );

							if ( $query->found_posts > 0 ) {
								echo '<h4 class="col-md-12 found-tours">' . $query->found_posts . ' ' . esc_html__( 'Tours Found!', 'inspiry-tourpress' ) . ' </h4>';
							}

							// The Loop
							if ( $query->have_posts() ) {

								$count = 1;

								while ( $query->have_posts() ) {
									$query->the_post();
									$tour_meta = get_post_custom();
									?>
									<div class="col-sm-6 col-md-4">
										<?php get_template_part( 'partials/tour/tour' ) ?>
									</div>
									<?php

									if ( $count % 2 == 0 ) {
										echo '<div class="visible-sm clearfix"></div>';
									}

									if ( $count % 3 == 0 ) {
										echo '<div class="visible-md visible-lg clearfix"></div>';
									}

									$count ++;
								}

							} else {
								inspiry_no_posts( esc_html__( 'Tour', 'inspiry-tourpress' ) );
							}

							inspiry_pagination( $query ); ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php

get_footer();
?>