<?php
/**
 * Template Name: Tours List
 */
get_header();
?>
<!-- tours listing -->
<div id="content-wrapper" class="site-page tour-listing <?php tourpress_content_width('sidebar-tour'); ?>">
	<div class="container">
		<div class="row">
			<?php
				if ( have_posts() ) {
					the_post();
					$page_contents = get_the_content();

					if ( ! empty( $page_contents ) ) {
						?>
						<div class="col-md-12 col-main-content listing-page-content entry-content">
							<?php the_content(); ?>
						</div>
						<?php
					}
				}
			?>
			<div class="col-md-8 col-main-content tours-list-container">
				<div class="tours-listing">
					<div class="row">
						<?php
                            global $paged;

                            // WP_Query arguments
                            $args = array(
                                'post_type'      => 'tour',
                                'paged'          => $paged,
                                'posts_per_page' => 4
                            );

                            // Apply tours filter.
                            $args = apply_filters( 'inspiry_tours_filter', $args );

							// The Query
							$query = new WP_Query( $args );

							// The Loop
							if ( $query->have_posts() ) {
								$count = 1;
								while ( $query->have_posts() ) {
									$query->the_post();
									$tour_meta = get_post_custom();
									?>
									<div class="col-xs-12 col-sm-6 col-lg-12">
										<?php get_template_part( 'partials/tour/tour' ); ?>
									</div>
									<?php

									if ( $count % 2 == 0 ) {
										echo '<div class="clearfix visible-sm visible-md"></div>';
									}

									$count ++;
								}
							} else {
								inspiry_no_posts( esc_html__( 'Tours', 'inspiry-tourpress' ) );
							}

							inspiry_pagination( $query ); ?>
					</div>
				</div>
			</div>
            <?php get_sidebar( 'tour' ); ?>
		</div>
	</div>
</div>
<?php

get_footer();
?>