<?php
/**
 * Template Name: Tours Gallery
 */
get_header();
?>
<!-- tours gallery -->
<div id="content-wrapper" class="site-page tour-gallery">
	<div class="container">
		<div class="row">
			<div class="col-sm-12 col-main-content tours-gallery">
				<?php
					$title       = get_theme_mod( 'inspiry_travel_destinations_title', esc_html__( 'Travel Destinations', 'inspiry-tourpress' ) );
					$description = get_theme_mod( 'inspiry_travel_destinations_description' );

					inspiry_section_heading( $title, $description );

					$terms = get_terms( array(
						'taxonomy'   => 'tour-destination',
						'hide_empty' => true,
						'number'     => 6
					) );

					if ( ! empty( $terms ) ) {
						?>
						<div class="tours-sorter clearfix">
							<ul id="filters">
								<li>
									<a href="#" data-filter="*" class="active"><?php esc_html_e( 'All', 'inspiry-tourpress' ); ?></a>
								</li>
								<?php
									foreach ( $terms as $term ) {
										echo '<li><a href="#" data-filter=".' . $term->slug . '" >' . $term->name . '</a>';
									}
								?>
							</ul>
						</div>
						<?php
					}
				?>
				<div class="row" id="items-list">
					<?php
					    global $paged;

						// WP_Query arguments
						$args = array(
							'post_type'      => 'tour',
							'paged'          => $paged,
							'posts_per_page' => 500
						);

						// The Query
						$query = new WP_Query( $args );

						// The Loop
						if ( $query->have_posts() ) {
							while ( $query->have_posts() ) {
								$query->the_post();
								$tour_meta = get_post_custom();

								$termsArray  = get_the_terms( get_the_ID(), "tour-destination" );  //Get the terms for this particular item
								$termsString = ""; //initialize the string that will contain the terms

								if ( false !== $termsArray ) {

									foreach ( $termsArray as $term ) {
										$termsString .= $term->slug . ' ';
									}
								}

								if ( has_post_thumbnail() ) {
									?>
									<div class="col-xs-12 col-sm-6 col-md-4 item <?php echo esc_attr( $termsString ); ?>">
										<div class="gallery-item clearfix">
											<figure>
												<?php
													// tour featured image
													the_post_thumbnail( 'inspiry_image_size_720_560' );
												?>
											</figure>
											<div class="item-content">
												<h3>
													<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
												</h3>
											</div>
										</div>
									</div>
									<?php
								}
							}
						} else {
							inspiry_no_posts( esc_html__( 'Tours', 'inspiry-tourpress' ) );
						}
					?>
				</div>
			</div>
		</div>
	</div>
</div>
<?php
get_footer();
?>