<?php
/**
 * Template Name: Home
 */
get_header();

?>
<div id="content-wrapper" role="main" class="home-page">
	<?php
		// banner or default slider or slider revolution
		get_template_part( 'partials/home/slider' );

		// homepage sections display and order by default
		$defaults = 'features,featured-packages,travel-destinations,special-offers,mood-destinations,blog,testimonials,explore-tours';

		// homepage sections
		$visible_sections = explode( ',', get_theme_mod( 'inspiry_home_sections_display' ) );
		$home_sections    = explode( ',', get_theme_mod( 'inspiry_home_sections_order', 'contents,' . $defaults ) );

		foreach ( $home_sections as $section ) {

			if ( in_array( $section, $visible_sections ) ) {
				get_template_part( 'partials/home/' . $section );
			}

		}
	?>
</div>
<?php get_footer(); ?>