<?php
/**
 * Register meta boxes related to pages
 *
 * @param   array $meta_boxes
 *
 * @since   1.0.0
 * @return  array   $meta_boxes
 */

if ( ! function_exists( 'inspiry_pages_metaboxes' ) ) {
	function inspiry_pages_metaboxes( $meta_boxes ) {

		$prefix             = 'Inspiry_Tours_';
		$google_map_api_key = inspiry_get_google_map_api_key();

		// Page Meta Box Settings
		$meta_boxes[] = array(
			'id'       => 'page-meta-box',
			'title'    => esc_html__( 'Banner Configuration', 'inspiry-tourpress' ),
			'pages'    => array( 'page', 'post' ),
			'context'  => 'normal',
			'priority' => 'high',
			'fields'   => array(
				array(
					'name' => esc_html__( 'Banner Title', 'inspiry-tourpress' ),
					'id'   => "{$prefix}page_title",
					'type' => 'text',
				),
				array(
					'name'             => esc_html__( 'Banner Image', 'inspiry-tourpress' ),
					'desc'             => esc_html__( 'Recommended banner image size is 1600px by 300px.', 'inspiry-tourpress' ),
					'id'               => "{$prefix}banner_image",
					'type'             => 'image_advanced',
					'max_file_uploads' => 1,
				),
			)
		);

		$destinations = array();
		inspiry_get_terms_array( 'tour-destination', $destinations );

		$types = array();
		inspiry_get_terms_array( 'tour-type', $types );

		$months = array();
		inspiry_get_terms_array( 'tour-month', $months );

		// Tours Listing Settings
		$meta_boxes[] = array(
			'id'       => 'tours-page-meta-box',
			'title'    => esc_html__( 'Tours Listing Configuration', 'inspiry-tourpress' ),
			'pages'    => array( 'page' ),
			'context'  => 'normal',
			'priority' => 'high',
			'show'     => array(
				'template' => array(
					'page-templates/tours-grid.php',
					'page-templates/tours-grid-fullwidth.php',
					'page-templates/tours-list.php',
				),
			),
			'fields'     => array(
				array(
					'id'      => "{$prefix}posts_number",
					'name'    => esc_html__( 'Number of Tours Per Page', 'inspiry-tourpress' ),
					'type'    => 'number',
					'step'    => '1',
					'min'     => 1,
					'std'     => 6,
					'columns' => 6,
				),
				array(
					'id'      => "{$prefix}tours_max_price",
					'name'    => esc_html__( 'Maximum Price', 'inspiry-tourpress' ),
					'type'    => 'number',
					'step'    => 'any',
					'min'     => 0,
					'std'     => 0,
					'columns' => 6,
				),
				array(
					'id'              => "{$prefix}tours_destinations",
					'name'            => esc_html__( 'Destinations', 'inspiry-tourpress' ),
					'type'            => 'select',
					'options'         => $destinations,
					'multiple'        => true,
					'select_all_none' => true,
					'columns'         => 4,
				),
				array(
					'id'              => "{$prefix}tours_types",
					'name'            => esc_html__( 'Types', 'inspiry-tourpress' ),
					'type'            => 'select',
					'options'         => $types,
					'multiple'        => true,
					'select_all_none' => true,
					'columns'         => 4,
				),
				array(
					'id'              => "{$prefix}tours_months",
					'name'            => esc_html__( 'Months', 'inspiry-tourpress' ),
					'type'            => 'select',
					'options'         => $months,
					'multiple'        => true,
					'select_all_none' => true,
					'columns'         => 4,
				),
			),
		);

		// Home Page Meta Box Settings
		$meta_boxes[] = array(
			'id'       => 'home-meta-box',
			'title'    => esc_html__( 'Features List on Homepage', 'inspiry-tourpress' ),
			'pages'    => array( 'page' ),
			'context'  => 'normal',
			'priority' => 'high',
			'show'     => array(
				'template' => array( 'page-templates/home.php' )
			),
			'fields'   => array(
				array(
					'name' => esc_html__( 'Features Section Title', 'inspiry-tourpress' ),
					'id'   => "{$prefix}features_title",
					'type' => 'text',
				),
				array(
					'name' => esc_html__( 'Features Section Description', 'inspiry-tourpress' ),
					'id'   => "{$prefix}features_description",
					'type' => 'textarea',
				),
				array(
					'type' => 'divider',
				),
				array(
					'name'       => esc_html__( 'Features List', 'inspiry-tourpress' ),
					'id'         => 'features',
					'type'       => 'group',
					'clone'      => true,
					'sort_clone' => true,
					'fields'     => array(
						array(
							'name' => esc_html__( 'Title', 'inspiry-tourpress' ),
							'id'   => "{$prefix}title",
							'type' => 'text',
						),
						array(
							'name' => esc_html__( 'Description', 'inspiry-tourpress' ),
							'id'   => "{$prefix}description",
							'type' => 'textarea',
						),
						array(
							'name' => esc_html__( 'URL', 'inspiry-tourpress' ),
							'id'   => "{$prefix}url",
							'type' => 'text',
						),
						array(
							'name'             => esc_html__( 'Icon', 'inspiry-tourpress' ),
							'id'               => "{$prefix}icon",
							'type'             => 'image_advanced',
							'max_file_uploads' => 1,
						),
					)
				),
			),
		);

		// Contact Page Meta Box Settings
		$meta_boxes[] = array(
			'id'          => 'contact-meta-box',
			'title'       => esc_html__( 'Contact Information', 'inspiry-tourpress' ),
			'pages'       => array( 'page' ),
			'context'     => 'normal',
			'priority'    => 'high',
			'show'        => array(
				'template' => array( 'page-templates/contact.php' )
			),
			'tabs'        => array(
				'map'            => array(
					'label' => esc_html__( 'Map Location', 'inspiry-tourpress' ),
					'icon'  => 'dashicons-location-alt',
				),
				'form'           => array(
					'label' => esc_html__( 'Contact Form', 'inspiry-tourpress' ),
					'icon'  => 'dashicons-email',
				),
				'social_profile' => array(
					'label' => esc_html__( 'Social Profiles', 'inspiry-tourpress' ),
					'icon'  => 'dashicons-share',
				),
				'office'         => array(
					'label' => esc_html__( 'Offices', 'inspiry-tourpress' ),
					'icon'  => 'dashicons-building',
				)
			),
			'tab_style'   => 'left',
			'tab_wrapper' => true,
			'fields'      => array(
				// contact form section
				array(
					'name'    => esc_html__( 'Section Display', 'inspiry-tourpress' ),
					'id'      => "{$prefix}form_display",
					'std'     => 'show',
					'type'    => 'radio',
					'tab'     => 'form',
					'options' => array(
						'show' => esc_html__( 'Show', 'inspiry-tourpress' ),
						'hide' => esc_html__( 'Hide', 'inspiry-tourpress' ),
					),
				),
				array(
					'name' => esc_html__( 'Contact Form Email', 'inspiry-tourpress' ),
					'desc' => esc_html__( 'Please provide an email address where you would like to receive the contact form requests.', 'inspiry-tourpress' ),
					'id'   => "{$prefix}form_email",
					'type' => 'text',
					'tab'  => 'form'
				),
				array(
					'name' => esc_html__( 'Contact Form Shortcode', 'inspiry-tourpress' ),
					'desc' => 'If you want to use an alternative contact form e.g <a href="https://wordpress.org/plugins/contact-form-7/" target="_blank">Contact form 7</a>, then you can provide its shortcode here.',
					'id'   => "{$prefix}form_shortcode",
					'type' => 'text',
					'tab'  => 'form'
				),
				// social profiles section
				array(
					'name'    => esc_html__( 'Section Display', 'inspiry-tourpress' ),
					'id'      => "{$prefix}social_display",
					'std'     => 'show',
					'type'    => 'radio',
					'tab'     => 'social_profile',
					'options' => array(
						'show' => esc_html__( 'Show', 'inspiry-tourpress' ),
						'hide' => esc_html__( 'Hide', 'inspiry-tourpress' ),
					),
				),
				array(
					'name' => esc_html__( 'Section Title', 'inspiry-tourpress' ),
					'id'   => "{$prefix}social_title",
					'type' => 'text',
					'tab'  => 'social_profile'
				),
				array(
					'type' => 'heading',
					'name' => esc_html__( 'Social Profile Links', 'inspiry-tourpress' ),
					'desc' => esc_html__( 'Provide the social profile links into the related fields given below.', 'inspiry-tourpress' ),
					'tab'  => 'social_profile'
				),
				array(
					'name' => esc_html__( 'Facebook', 'inspiry-tourpress' ),
					'id'   => "{$prefix}facebook_profile",
					'type' => 'text',
					'tab'  => 'social_profile'
				),
				array(
					'name' => esc_html__( 'Twitter', 'inspiry-tourpress' ),
					'id'   => "{$prefix}twitter_profile",
					'type' => 'text',
					'tab'  => 'social_profile'
				),
				array(
					'name' => esc_html__( 'Instagram', 'inspiry-tourpress' ),
					'id'   => "{$prefix}instagram_profile",
					'type' => 'text',
					'tab'  => 'social_profile'
				),
				array(
					'name' => esc_html__( 'Pinterest', 'inspiry-tourpress' ),
					'id'   => "{$prefix}pinterest_profile",
					'type' => 'text',
					'tab'  => 'social_profile'
				),
				// offices
				array(
					'name'    => esc_html__( 'Section Display', 'inspiry-tourpress' ),
					'id'      => "{$prefix}offices_display",
					'std'     => 'show',
					'type'    => 'radio',
					'tab'     => 'office',
					'options' => array(
						'show' => esc_html__( 'Show', 'inspiry-tourpress' ),
						'hide' => esc_html__( 'Hide', 'inspiry-tourpress' ),
					),
				),
				array(
					'type' => 'heading',
					'name' => esc_html__( 'Head Office', 'inspiry-tourpress' ),
					'tab'  => 'office'
				),
				array(
					'name' => esc_html__( 'Section Title', 'inspiry-tourpress' ),
					'id'   => "{$prefix}office_head_title",
					'std'  => 'Head Office',
					'type' => 'text',
					'tab'  => 'office'
				),
				// DIVIDER
				array(
					'type' => 'divider',
					'tab'  => 'office'
				),
				array(
					'name'    => esc_html__( 'Location', 'inspiry-tourpress' ),
					'id'      => "{$prefix}office_location",
					'type'    => 'text',
					'columns' => 6,
					'tab'     => 'office'
				),
				array(
					'name'    => esc_html__( 'Working Days', 'inspiry-tourpress' ),
					'id'      => "{$prefix}working_days",
					'std'     => esc_html__( 'Monday to Friday', 'inspiry-tourpress' ),
					'type'    => 'text',
					'columns' => 6,
					'tab'     => 'office'
				),
				array(
					'name'    => esc_html__( 'Address', 'inspiry-tourpress' ),
					'id'      => "{$prefix}office_address",
					'type'    => 'text',
					'columns' => 6,
					'tab'     => 'office'
				),
				array(
					'name'    => esc_html__( 'Working Time', 'inspiry-tourpress' ),
					'id'      => "{$prefix}working_time",
					'std'     => esc_html__( '9.00 am to 5.00 pm', 'inspiry-tourpress' ),
					'type'    => 'text',
					'columns' => 6,
					'tab'     => 'office'
				),
				array(
					'name'    => esc_html__( 'Phone Number', 'inspiry-tourpress' ),
					'id'      => "{$prefix}office_number",
					'type'    => 'text',
					'columns' => 6,
					'tab'     => 'office'
				),
				array(
					'name'    => esc_html__( 'Off Days', 'inspiry-tourpress' ),
					'id'      => "{$prefix}working_off",
					'std'     => esc_html__( 'Saturday & Sunday', 'inspiry-tourpress' ),
					'type'    => 'text',
					'columns' => 6,
					'tab'     => 'office'
				),
				array(
					'name'    => esc_html__( 'Email', 'inspiry-tourpress' ),
					'id'      => "{$prefix}office_email",
					'type'    => 'text',
					'columns' => 6,
					'tab'     => 'office'
				),
				array(
					'name'    => esc_html__( 'Off Days Label', 'inspiry-tourpress' ),
					'id'      => "{$prefix}working_off_label",
					'std'     => esc_html__( 'Closed', 'inspiry-tourpress' ),
					'type'    => 'text',
					'columns' => 6,
					'tab'     => 'office'
				),
				array(
					'type' => 'heading',
					'name' => esc_html__( 'Branch Offices', 'inspiry-tourpress' ),
					'tab'  => 'office'
				),
				array(
					'name' => esc_html__( 'Section Title', 'inspiry-tourpress' ),
					'id'   => "{$prefix}office_branch_title",
					'std'  => 'Branch Office',
					'type' => 'text',
					'tab'  => 'office'
				),
				// DIVIDER
				array(
					'type' => 'divider',
					'tab'  => 'office'
				),
				array(
					'id'         => 'branch_offices',
					'type'       => 'group',
					'clone'      => true,
					'sort_clone' => true,
					'tab'        => 'office',
					'fields'     => array(
						array(
							'name'    => esc_html__( 'Location', 'inspiry-tourpress' ),
							'id'      => "{$prefix}office_br_location",
							'columns' => 3,
							'type'    => 'text',
						),
						array(
							'name'    => esc_html__( 'Address', 'inspiry-tourpress' ),
							'id'      => "{$prefix}office_br_address",
							'columns' => 3,
							'type'    => 'text',
						),
						array(
							'name'    => esc_html__( 'Phone Number', 'inspiry-tourpress' ),
							'id'      => "{$prefix}office_br_number",
							'columns' => 3,
							'type'    => 'text',
						),
						array(
							'name'    => esc_html__( 'Email', 'inspiry-tourpress' ),
							'id'      => "{$prefix}office_br_email",
							'columns' => 3,
							'type'    => 'email',
						),
					)
				),
				// map location section
				array(
					'name'    => esc_html__( 'Section Display', 'inspiry-tourpress' ),
					'id'      => "{$prefix}map_display",
					'std'     => 'show',
					'type'    => 'radio',
					'tab'     => 'map',
					'columns' => 6,
					'options' => array(
						'show' => esc_html__( 'Show', 'inspiry-tourpress' ),
						'hide' => esc_html__( 'Hide', 'inspiry-tourpress' ),
					),
				),
				array(
					'name'    => esc_html__( 'Section Title', 'inspiry-tourpress' ),
					'id'      => "{$prefix}map_title",
					'type'    => 'text',
					'tab'     => 'map',
					'columns' => 6,
				),
				array(
					'id'      => "{$prefix}map_address",
					'name'    => esc_html__( 'Map Address', 'inspiry-tourpress' ),
					'type'    => 'text',
					'std'     => esc_html__( 'New York, NY, USA', 'inspiry-tourpress' ),
					'columns' => 12,
					'tab'     => 'map'
				),
				array(
					'id'            => "inspiry_tour_map_location",
					'name'          => esc_html__( 'Map Location', 'inspiry-tourpress' ),
					'type'          => 'map',
					'std'           => '40.715923,-74.008924,11',
					'address_field' => "{$prefix}map_address",
					'api_key'       => esc_html( $google_map_api_key ),
					'columns'       => 12,
					'tab'           => 'map'
				),

			)
		);

		// apply a filter before returning meta boxes
		$meta_boxes = apply_filters( 'inspiry_page_meta_boxes', $meta_boxes );

		return $meta_boxes;
	}

	add_filter( 'rwmb_meta_boxes', 'inspiry_pages_metaboxes' );
}