<?php
/**
 * Price Functions
 */
if ( ! function_exists( 'inspiry_price' ) ) {
	/**
	 * Display tour current price or discounted price
	 * whether formatted or numeric value
	 *
	 * @param $format // formatted price
	 * @param $discounted //display discounted price
	 */
	function inspiry_price( $format = true, $discounted = false ) {
		echo inspiry_get_price( $format, $discounted );
	}
}

if ( ! function_exists( 'inspiry_get_price' ) ) {
	/**
	 * Return tour price
	 *
	 * @param $format // formatted price
	 * @param $discounted //display discounted price
	 *
	 * @return mixed
	 */
	function inspiry_get_price( $format = true, $discounted = false ) {

		$price_key    = ( $discounted ) ? 'inspiry_tour_price_dis' : 'inspiry_tour_price';
		$price_format = get_option( 'easy_tours_price_format_option' );

		$currency      = $price_format['currency_sign'];
		$currency_pos  = $price_format['currency_position'];
		$decimals      = $price_format['number_of_decimals'];
		$dec_point     = $price_format['decimal_separator'];
		$thousands_sep = $price_format['thousand_separator'];

		$amount = get_post_meta( get_the_ID(), $price_key, true );

		if ( $discounted && empty( $amount ) ) {
			$amount = get_post_meta( get_the_ID(), 'inspiry_tour_price', true );
		}

		if ( ! empty( $amount ) ) {

			if ( $format ) {

				$formatted_amount = number_format( floatval( $amount ), intval( $decimals ), esc_html( $dec_point ), esc_html( $thousands_sep ) );

				if ( $currency_pos == 'before' ) {
					$price = esc_html( $currency ) . $formatted_amount;
				} else {
					$price = $formatted_amount . esc_html( $currency );
				}
			} else {
				$price = $amount;
			}

		} else {
			$price = no_price_alt( $price_format['empty_price_text'] );
		}

		return $price;
	}
}

if ( ! function_exists( 'inspiry_has_price' ) ) {
	/**
	 * @param bool $discounted check for the discounted price
	 *
	 * @return bool
	 */
	function inspiry_has_price( $discounted = false ) {

		$price_key = ( $discounted ) ? 'inspiry_tour_price_dis' : 'inspiry_tour_price';
		$amount    = get_post_meta( get_the_ID(), $price_key, true );
		if ( ! empty( $amount ) && $amount != no_price_alt() ) {
			return true;
		}

		return false;
	}
}

function inspiry_get_price_postfix( $tour_id = '' ) {

	if ( empty( $tour_id ) ) {
		$tour_id = get_the_ID();
	}

	$price_postfix = get_post_meta( $tour_id, 'inspiry_tour_price_postfix', true );

	return $price_postfix;
}

if ( ! function_exists( 'no_price_alt' ) ) {
	/**
	 * Alternative text when no price is set
	 * @param $price_alt_text // default no price text
	 * @return string
	 */
	function no_price_alt( $price_alt_text = '' ) {

		if ( ! empty( $price_alt_text ) ) {
			$no_price = $price_alt_text;
		} else {
			$no_price = esc_html__( 'N/A', 'inspiry-tourpress' );
		}

		return $no_price;
	}
}