<?php

if ( ! function_exists( 'inspiry_comment_fields_placeholder' ) ) {
	/**
	 * Update default comment form fields to add placeholders
	 *
	 * @param $fields
	 *
	 * @return mixed
	 */
	function inspiry_comment_fields_placeholder( $fields ) {

		$commenter = wp_get_current_commenter();
		$req       = get_option( 'require_name_email' );
		$aria_req  = $req ? "aria-required='true'" : '';

		$fields['author'] =
			'<p class="comment-form-author">
				<input id="author" name="author" type="text" placeholder="' . esc_attr__( 'Name*', 'inspiry-tourpress' ) . '" value="' . esc_attr( $commenter['comment_author'] ) . '" ' . $aria_req . ' />
			</p>';

		$fields['email'] =
			'<p class="comment-form-email">
				<input id="email" name="email" type="email" placeholder="' . esc_attr__( 'Email Address*', 'inspiry-tourpress' ) . '" value="' . esc_attr( $commenter['comment_author_email'] ) . '" ' . $aria_req . ' />
			</p>';

		$fields['url'] =
			'<p class="comment-form-url">
				<input id="url" name="url" type="url"  placeholder="' . esc_attr__( 'Website', 'inspiry-tourpress' ) . '" value="' . esc_attr( $commenter['comment_author_url'] ) . '" />
			</p>';

		return $fields;
	}

	add_filter( 'comment_form_default_fields', 'inspiry_comment_fields_placeholder' );
}

if ( ! function_exists( 'inspiry_comment_list' ) ) {
	/**
	 * Displays post comments list
	 * @since   1.0.0
	 *
	 * @param   $comment // user comment
	 * @param   $args // user comment arguments
	 * @param   $depth // depth of a comment reply
	 *
	 * @return  void
	 */
	function inspiry_comment_list( $comment, $args, $depth ) {

		?>

		<li <?php comment_class( empty( $args['has_children'] ) ? 'clearfix' : 'parent clearfix' ) ?>
			id="comment-<?php comment_ID() ?>">
			<article class="comment-body clearfix">

				<?php if ( $args['avatar_size'] != 0 ) {

					$avatar = get_avatar( $comment, $args['avatar_size'] );

					if ( false !== $avatar ) {
						?>
						<div class="author-photo">
							<?php
								echo apply_filters( 'inspiry_comment_avatar', $avatar );
							?>
						</div>
						<?php
					}

				} ?>

				<div class="comment-wrapper">

					<?php if ( $comment->comment_approved == '0' ) : ?>
						<em class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'inspiry-tourpress' ); ?></em>
						<br/>
					<?php endif; ?>

					<div class="comment-meta clearfix">
						<div class="comment-author vcard">
							<h5 class="fn"><?php comment_author_link( $comment->comment_ID ); ?></h5>
						</div>
						<div class="comment-metadata">
							<a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ); ?>">
								<span><?php printf( '%1$s', get_comment_date( 'F j, Y' ) ); ?></span> </a>
							<?php edit_comment_link( esc_html__( '(Edit)', 'inspiry-tourpress' ), '  ', '' ); ?>
						</div>
					</div>

					<div class="comment-content entry-content">
						<?php comment_text(); ?>
					</div>
					<?php
						if ( ! is_singular( 'tour' ) ) {
							?>
							<div class="reply">
								<?php comment_reply_link( array_merge( $args, array(
									'add_below' => 'comment',
									'depth'     => $depth,
									'max_depth' => $args['max_depth']
								) ) ); ?>
							</div>
							<?php
						}
					?>
				</div>

			</article>
			<!-- end of comment -->
		<?php
	}
}