<?php


if ( ! function_exists( 'inspiry_comment_form_fields' ) ) {
	/**
	 * Add rating field above the default contact form fields
	 */
	function inspiry_comment_form_fields() {

		if ( ! is_singular( 'tour' ) ) {
			return;
		}

		?>
		<div class="inspiry-comment-rating">
			<div class="rating-box">
				<select id="rate-it" name="rating">
					<?php
						for ( $i = 1; $i <= 5; $i ++ ) {
							echo '<option value="' . $i . '">' . $i . '</option>';
						}
					?>
				</select>
			</div>
		</div>
		<?php
	}

	add_action( 'comment_form_logged_in_before', 'inspiry_comment_form_fields' );
	add_action( 'comment_form_top', 'inspiry_comment_form_fields' );
}

if ( ! function_exists( 'inspiry_modify_comment' ) ) {
	/**
	 * Add the comment meta (saved earlier) underneath comment avatar
	 */
	function inspiry_modify_comment( $avatar ) {

		if ( ( $rating = get_comment_meta( get_comment_ID(), 'rating', true ) ) && is_singular( 'tour' ) ) {

			$rating = '<p>' . inspiry_get_rating_stars( $rating ) . '</p>';

			return $avatar . $rating;

		} else {
			return $avatar;
		}
	}

	add_filter( 'inspiry_comment_avatar', 'inspiry_modify_comment' );
}

if ( ! function_exists( 'inspiry_save_comment_meta_data' ) ) {
	/**
	 * Save the comment meta data along with comment
	 */
	function inspiry_save_comment_meta_data( $comment_id ) {

		if ( ( isset( $_POST['rating'] ) ) && ( $_POST['rating'] != '' ) ) {
			$rating = wp_filter_nohtml_kses( $_POST['rating'] );
			add_comment_meta( $comment_id, 'rating', $rating );
		}

	}

	add_action( 'comment_post', 'inspiry_save_comment_meta_data' );
}

if ( ! function_exists( 'inspiry_set_avg_rating' ) ) {
	/**
	 * Set average rating for the tour
	 */
	function inspiry_set_avg_rating( $comment_id ) {

		if ( empty( $comment_id ) ) {
			return;
		}

		$comment         = get_comment( $comment_id );
		$comment_post_id = $comment->comment_post_ID;

		$args = array(
			'post_id' => $comment_post_id,
			'status'  => 'approve'
		);

		$comments = get_comments( $args );
		$ratings  = array();

		foreach ( $comments as $comment ) {

			$rating = get_comment_meta( $comment->comment_ID, 'rating', true );

			if ( ! empty( $rating ) ) {
				$ratings[] = absint( $rating );
			}
		}

		if ( ! empty( $ratings ) ) {

			$avg = round( array_sum( $ratings ) / count( $ratings ) );

			update_post_meta( $comment_post_id, 'inspiry_tour_avg_rating', $avg );
			update_post_meta( $comment_post_id, 'inspiry_tour_reviews_count', count( $ratings ) );

		} else {
			update_post_meta( $comment_post_id, 'inspiry_tour_avg_rating', 0 );
			update_post_meta( $comment_post_id, 'inspiry_tour_reviews_count', 0 );
		}
	}

	add_action( 'comment_post', 'inspiry_set_avg_rating' );
	add_action( 'trash_comment', 'inspiry_set_avg_rating' );
	add_action( 'edit_comment', 'inspiry_set_avg_rating' );
	add_action( 'untrash_comment', 'inspiry_set_avg_rating' );
}

if ( ! function_exists( 'inspiry_approve_comment_callback' ) ) {
	/**
	 * @param $new_status // comment new status
	 * @param $old_status // comment old status
	 * @param $comment // comment being moderate
	 */
	function inspiry_approve_comment_callback( $new_status, $old_status, $comment ) {

		// set average rating based on comment being moderate
		inspiry_set_avg_rating( $comment->comment_ID );
	}

	add_action( 'transition_comment_status', 'inspiry_approve_comment_callback', 10, 3 );
}

if ( ! function_exists( 'inspiry_rating_stars' ) ) {
	/**
	 * @param int $rating
	 */
	function inspiry_rating_stars( $rating = 0 ) {

		echo inspiry_get_rating_stars( $rating );
	}
}

if ( ! function_exists( 'inspiry_get_rating_stars' ) ) {
	/**
	 * @param int $rating
	 *
	 * @return string // rating markup
	 */
	function inspiry_get_rating_stars( $rating = 0 ) {

		$output = '';

		$output = '<span class="rating">';

		for ( $count = 1; $count <= $rating; $count ++ ) {
			$output .= '<i class="fa fa-star-o rated"></i>';
		}

		$unrated = 5 - $rating;
		for ( $count = 1; $count <= $unrated; $count ++ ) {
			$output .= '<i class="fa fa-star-o"></i>';
		}

		$output .= '</span>';

		return $output;
	}
}

if ( ! function_exists( 'inspiry_avg_rating_stars' ) ) {
	/**
	 * Display average rating
	 */
	function inspiry_avg_rating_stars() {

		$avg_rating = get_post_meta( get_the_ID(), 'inspiry_tour_avg_rating', true );

		if ( isset( $avg_rating ) && ! empty( $avg_rating ) ) {

			inspiry_rating_stars( $avg_rating );

		} else {
			inspiry_rating_stars();
		}

	}
}
