<?php
if ( ! function_exists( 'inspiry_breadcrumbs' ) ) {
	/**
	 * Breadcrumbs for the posts and pages
	 */
	function inspiry_breadcrumbs() {

		if ( is_search() || is_singular( 'post' ) ) {
			return;
		}

		// Settings
		$breadcrums_id    = 'inspiry_breadcrumbs';
		$breadcrums_class = 'inspiry_breadcrumbs';
		$home_title       = esc_html__( 'Home', 'inspiry-tourpress' );
		$prefix           = '';

		// custom post types with custom taxonomies, (e.g. product_cat)
		$custom_taxonomy = 'destination';

		// Get the query & post information
		global $post, $wp_query;

		// Do not display on the homepage
		if ( ! is_front_page() ) {

			// Build the breadcrums
			echo '<ul id="' . esc_attr( $breadcrums_id ) . '" class="' . esc_attr( $breadcrums_class ) . '">';

			echo '<li class="breadcrumb-item"><a href="' . esc_url( get_home_url( '/' ) ) . '" title="' . esc_attr( $home_title ) . '">' . esc_html( $home_title ) . '</a></li>';

			// Home page
			if ( is_home() ) {

				echo '<li>&gt;</li><li class="breadcrumb-item active">' . inspiry_blog_title() . '</li>';
			}

			if ( is_archive() && ! is_tax() && ! is_category() && ! is_tag() && ! is_author() && ! is_day() && ! is_year() && ! is_month() ) {

				echo '<li>&gt;</li><li class="breadcrumb-item active"><span>' . post_type_archive_title( $prefix, false ) . '</span></li>';

			} else if ( is_archive() && is_tax() && ! is_category() && ! is_tag() && ! is_author() && ! is_day() && ! is_year() && ! is_month() ) {

				// If post is a custom post type
				$post_type = get_post_type();

				// If it is a custom post type display name and link
				if ( $post_type != 'post' ) {

					$post_type_object  = get_post_type_object( $post_type );
					$post_type_archive = get_post_type_archive_link( $post_type );

					if ( $post_type_object && $post_type_archive ) {
						echo '<li>&gt;</li><li class="breadcrumb-item item-cat item-custom-post-type-' . esc_attr( $post_type ) . '"><a class="bread-cat bread-custom-post-type-' . esc_attr( $post_type ) . '" href="' . esc_url( $post_type_archive ) . '" title="' . esc_attr( $post_type_object->labels->name ) . '">' . esc_html( $post_type_object->labels->name ) . '</a></li>';
					}
				}

				$custom_tax_name = get_queried_object()->name;
				echo '<li>&gt;</li><li class="breadcrumb-item active"><span>' . $custom_tax_name . '</span></li>';

			} else if ( is_single() ) {

				// If post is a custom post type
				$post_type = get_post_type();

				// If it is a custom post type display name and link
				if ( $post_type != 'post' ) {

					$post_type_object  = get_post_type_object( $post_type );
					$post_type_archive = get_post_type_archive_link( $post_type );

					if ( $post_type_object && $post_type_archive ) {
						echo '<li>&gt;</li><li class="breadcrumb-item item-cat item-custom-post-type-' . esc_attr( $post_type ) . '"><a class="bread-cat bread-custom-post-type-' . esc_attr( $post_type ) . '" href="' . esc_url( $post_type_archive ) . '" title="' . esc_attr( $post_type_object->labels->name ) . '">' . esc_html( $post_type_object->labels->name ) . '</a></li>';
					}
				} else {
					$blog_page_id = get_option( 'page_for_posts' );
					if ( $blog_page_id ) {
						$blog_title = get_the_title( $blog_page_id );
						$blog_url   = get_permalink( $blog_page_id );
						echo '<li>&gt;</li><li class="breadcrumb-item"><a class="blog-page" href="' . esc_url( $blog_url ) . '" title="' . esc_attr( $blog_title ) . '">' . esc_html( $blog_title ) . '</a></li>';
					}
				}

				// Get post category info
				$category = get_the_category();

				if ( ! empty( $category ) ) {

					// Get last category post is in
					$last_category = end( $category );

					// Get parent any categories and create array
					$get_cat_parents = rtrim( get_category_parents( $last_category->term_id, true, ',' ), ',' );
					$cat_parents     = explode( ',', $get_cat_parents );

					// Loop through parent categories and store in variable $cat_display
					$cat_display = '';
					foreach ( $cat_parents as $parents ) {
						$cat_display .= '<li>&gt;</li><li class="breadcrumb-item">' . $parents . '</li>';
					}

				}

				// If it's a custom post type within a custom taxonomy
				$taxonomy_exists = taxonomy_exists( $custom_taxonomy );

				if ( empty( $last_category ) && ! empty( $custom_taxonomy ) && $taxonomy_exists ) {

					$taxonomy_terms = get_the_terms( get_the_ID(), $custom_taxonomy );

					if ( ! empty( $taxonomy_terms ) ) {
						$cat_id       = $taxonomy_terms[0]->term_id;
						$cat_nicename = $taxonomy_terms[0]->slug;
						$cat_link     = get_term_link( $taxonomy_terms[0]->term_id, $custom_taxonomy );
						$cat_name     = $taxonomy_terms[0]->name;
					}
				}

				// Check if the post is in a category
				if ( ! empty( $last_category ) ) {

					echo '<li>&gt;</li><li class="breadcrumb-item active item-current item-' . $post->ID . '"><span class="bread-current bread-' . $post->ID . '" title="' . esc_attr( get_the_title() ) . '">' . get_the_title() . '</span></li>';

					// Else if post is in a custom taxonomy
				} else if ( ! empty( $cat_id ) ) {

					echo '<li>&gt;</li><li class="breadcrumb-item item-cat item-cat-' . $cat_id . ' item-cat-' . $cat_nicename . '"><a class="bread-cat bread-cat-' . $cat_id . ' bread-cat-' . $cat_nicename . '" href="' . esc_url( $cat_link ) . '" title="' . esc_attr( $cat_name ) . '">' . $cat_name . '</a></li>';
					echo '<li>&gt;</li><li class="breadcrumb-item active item-current item-' . $post->ID . '"><span class="bread-current bread-' . $post->ID . '" title="' . esc_attr( get_the_title() ) . '">' . get_the_title() . '</span></li>';

				} else {

					echo '<li>&gt;</li><li class="breadcrumb-item active item-current item-' . $post->ID . '"><span class="bread-current bread-' . $post->ID . '" title="' . esc_attr( get_the_title() ) . '">' . get_the_title() . '</span></li>';

				}

			} else if ( is_category() ) {

				// Category page
				echo '<li>&gt;</li><li class="breadcrumb-item active item-current item-cat"><span class="bread-current bread-cat">' . single_cat_title( '', false ) . '</span></li>';

			} else if ( is_page() ) {

				// Standard page
				if ( $post->post_parent ) {

					// If child page, get parents
					$anc = get_post_ancestors( $post->ID );

					// Get parents in the right order
					$anc = array_reverse( $anc );

					// Parent page loop
					if ( ! isset( $parents ) ) {
						$parents = null;
					}
					foreach ( $anc as $ancestor ) {
						$parents .= '<li>&gt;</li><li class="breadcrumb-item item-parent item-parent-' . $ancestor . '"><a class="bread-parent bread-parent-' . $ancestor . '" href="' . get_permalink( $ancestor ) . '" title="' . esc_attr( get_the_title( $ancestor ) ) . '">' . get_the_title( $ancestor ) . '</a></li>';
					}

					// Display parent pages
					echo wp_kses(
						$parents,
						array(
							'li' => array(
								'class' => array()
							),
							'a'  => array(
								'class' => array(),
								'href'  => array(),
								'title' => array()
							)
						)
					);

					// Current page
					echo '<li>&gt;</li><li class="breadcrumb-item active item-current item-' . $post->ID . '"><span title="' . esc_attr( get_the_title() ) . '"> ' . get_the_title() . '</span></li>';

				} else {

					// Just display current page if not parents
					echo '<li>&gt;</li><li class="breadcrumb-item active item-current item-' . $post->ID . '"><span class="bread-current bread-' . $post->ID . '"> ' . get_the_title() . '</span></li>';

				}

			} else if ( is_tag() ) {

				// Tag page

				// Get tag information
				$term_id       = get_query_var( 'tag_id' );
				$taxonomy      = 'post_tag';
				$args          = 'include=' . $term_id;
				$terms         = get_terms( $taxonomy, $args );
				$get_term_id   = $terms[0]->term_id;
				$get_term_slug = $terms[0]->slug;
				$get_term_name = $terms[0]->name;

				// Display the tag name
				echo '<li>&gt;</li><li class="breadcrumb-item active item-current item-tag-' . $get_term_id . ' item-tag-' . $get_term_slug . '"><span class="bread-current bread-tag-' . $get_term_id . ' bread-tag-' . $get_term_slug . '">' . $get_term_name . '</span></li>';

			} elseif ( is_day() ) {

				// Day archive

				// Year link
				echo '<li>&gt;</li><li class="breadcrumb-item item-year item-year-' . get_the_time( 'Y' ) . '"><a class="bread-year bread-year-' . get_the_time( 'Y' ) . '" href="' . esc_url( get_year_link( get_the_time( 'Y' ) ) ) . '" title="' . esc_attr( get_the_time( 'Y' ) ) . '">' . get_the_time( 'Y' ) . ' ' . esc_html__( 'Archives', 'inspiry-tourpress' ) . '</a></li>';

				// Month link
				echo '<li>&gt;</li><li class="breadcrumb-item item-month item-month-' . get_the_time( 'm' ) . '"><a class="bread-month bread-month-' . get_the_time( 'm' ) . '" href="' . esc_url( get_month_link( get_the_time( 'Y' ), get_the_time( 'm' ) ) ) . '" title="' . esc_attr( get_the_time( 'M' ) ) . '">' . get_the_time( 'M' ) . ' ' . esc_html__( 'Archives', 'inspiry-tourpress' ) . '</a></li>';

				// Day display
				echo '<li>&gt;</li><li class="breadcrumb-item active item-current item-' . get_the_time( 'j' ) . '"><span class="bread-current bread-' . get_the_time( 'j' ) . '"> ' . get_the_time( 'jS' ) . ' ' . get_the_time( 'M' ) . ' ' . esc_html__( 'Archives', 'inspiry-tourpress' ) . '</span></li>';

			} else if ( is_month() ) {

				// Month Archive

				// Year link
				echo '<li>&gt;</li><li class="breadcrumb-item item-year item-year-' . get_the_time( 'Y' ) . '"><a class="bread-year bread-year-' . get_the_time( 'Y' ) . '" href="' . esc_url( get_year_link( get_the_time( 'Y' ) ) ) . '" title="' . esc_attr( get_the_time( 'Y' ) ) . '">' . get_the_time( 'Y' ) . ' ' . esc_html__( 'Archives', 'inspiry-tourpress' ) . '</a></li>';

				// Month display
				echo '<li>&gt;</li><li class="breadcrumb-item item-month item-month-' . get_the_time( 'm' ) . '"><span class="bread-month bread-month-' . get_the_time( 'm' ) . '" title="' . esc_attr( get_the_time( 'M' ) ) . '">' . get_the_time( 'M' ) . ' ' . esc_html__( 'Archives', 'inspiry-tourpress' ) . '</span></li>';

			} else if ( is_year() ) {

				// Display year archive
				echo '<li>&gt;</li><li class="breadcrumb-item active item-current item-current-' . get_the_time( 'Y' ) . '"><span class="bread-current bread-current-' . get_the_time( 'Y' ) . '" title="' . esc_attr( get_the_time( 'Y' ) ) . '">' . get_the_time( 'Y' ) . ' ' . esc_html__( 'Archives', 'inspiry-tourpress' ) . '</span></li>';

			} else if ( is_author() ) {

				// Auhor archive

				// Get the author information
				global $author;
				$userdata = get_userdata( $author );


				// Display author name
				echo '<li>&gt;</li><li class="breadcrumb-item active item-current item-current-' . $userdata->user_nicename . '"><span class="bread-current bread-current-' . $userdata->user_nicename . '" title="' . esc_attr( $userdata->display_name ) . '">' . esc_html__( 'Author:', 'inspiry-tourpress' ) . ' ' . $userdata->display_name . '</span></li>';

			} else if ( get_query_var( 'paged' ) ) {

				// Paginated archives
				echo '<li>&gt;</li><li class="breadcrumb-item active item-current item-current-' . get_query_var( 'paged' ) . '"><span class="bread-current bread-current-' . get_query_var( 'paged' ) . '" title="Page ' . get_query_var( 'paged' ) . '">' . esc_html__( 'Page', 'inspiry-tourpress' ) . ' ' . get_query_var( 'paged' ) . '</span></li>';

			} else if ( is_search() ) {

				// Search results page
				echo '<li>&gt;</li><li class="breadcrumb-item active item-current item-current-' . get_search_query() . '"><span class="bread-current bread-current-' . get_search_query() . '" title="Search results for: ' . get_search_query() . '">' . esc_html__( 'Search results for:', 'inspiry-tourpress' ) . ' ' . get_search_query() . '</span></li>';

			} elseif ( is_404() ) {

				// 404 page
				echo '<li>&gt;</li><li>' . esc_html__( 'Error 404', 'inspiry-tourpress' ) . '</li>';
			}

			echo '</ul>';

		}

	}
}