<?php

if ( ! function_exists( 'inspiry_import_files' ) ) {
	/**
	 * Demo contents import
	 */
	function inspiry_import_files() {
		return array(
			array(
				'import_file_name'             => esc_html__( 'TourPress Demo Import', 'inspiry-tourpress' ),
				'local_import_file'            => INSPIRY_INC_DIRECTORY . 'demo-import/import-files/content.xml',
				'local_import_widget_file'     => INSPIRY_INC_DIRECTORY . 'demo-import/import-files/widgets.wie',
				'local_import_customizer_file' => INSPIRY_INC_DIRECTORY . 'demo-import/import-files/customizer.dat',
				'import_notice'                => wp_specialchars_decode( esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported :) <br><br>After you import this demo, you will have to setup the permalinks settings to <strong>Post name</strong> from <code>Settings > Permalinks</code> page.', 'inspiry-tourpress' ) ),
			)
		);
	}

	add_filter( 'pt-ocdi/import_files', 'inspiry_import_files' );
}

if ( ! function_exists( 'inspiry_after_import' ) ) {
	/**
	 * Set up the news and front page plus menu locations
	 * @param $selected_import
	 */
	function inspiry_after_import( $selected_import ) {

		if ( 'TourPress Demo Import' === $selected_import['import_file_name'] ) {

			//Set Topbar & Header Menu
			$top_menu    = get_term_by( 'name', 'Topbar Menu', 'nav_menu' );
			$header_menu = get_term_by( 'name', 'Header Menu', 'nav_menu' );

			set_theme_mod( 'nav_menu_locations', array(
					'topbar-menu' => $top_menu->term_id,
					'header-menu' => $header_menu->term_id,
				)
			);

			//Set Front page
			$page         = get_page_by_title( 'Home' );
			$blog_page_id = get_page_by_title( 'News' );
			if ( isset( $page->ID ) ) {
				update_option( 'page_on_front', $page->ID );
				update_option( 'show_on_front', 'page' );
				update_option( 'page_for_posts', $blog_page_id->ID );
			}
		}

	}

	add_action( 'pt-ocdi/after_import', 'inspiry_after_import' );

}

// Disable PT advertisement
add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );