<?php

if ( ! function_exists( 'inspiry_shop_customizer' ) ) {
	/**
	 * Customizer settings for shop page
	 */
	function inspiry_shop_customizer( WP_Customize_Manager $wp_customize ) {

		$wp_customize->add_section( 'inspiry_shop_section', array(
			'title'    => esc_html__( 'Shop', 'inspiry-tourpress' ),
			'priority' => 191,
		) );


		// Registers shop page background image settings
		$wp_customize->add_setting( 'inspiry_shop_banner_image_url', array(
			'sanitize_callback' => 'esc_url'
		) );

		$wp_customize->add_setting( 'inspiry_shop_banner_image_id', array(
			'sanitize_callback' => 'absint'
		) );

		$wp_customize->add_setting( 'inspiry_shop_banner_repeat', array(
			'default'           => 'no-repeat',
			'sanitize_callback' => 'sanitize_text_field'
		) );

		$wp_customize->add_setting( 'inspiry_shop_banner_size', array(
			'default'           => 'cover',
			'sanitize_callback' => 'sanitize_text_field'
		) );

		$wp_customize->add_setting( 'inspiry_shop_banner_position', array(
			'default'           => 'center-center',
			'sanitize_callback' => 'sanitize_text_field'
		) );

		// banner image
		$wp_customize->add_control(
			new Customize_Custom_Background_Control(
				$wp_customize,
				'inspiry_shop_banner_image',
				array(
					'label'       => esc_html__( 'Banner Background Image', 'inspiry-tourpress' ),
					'description' => esc_html__( 'Required minimum width is 2000px and minimum height is 295px.', 'inspiry-tourpress' ),
					'section'     => 'inspiry_shop_section',
					'settings'    => array(
						'image_url' => 'inspiry_shop_banner_image_url',
						'image_id'  => 'inspiry_shop_banner_image_id',
						'repeat'    => 'inspiry_shop_banner_repeat', // Use false to hide the field
						'size'      => 'inspiry_shop_banner_size',
						'position'  => 'inspiry_shop_banner_position'
					)
				)
			)
		);

		// separator
		$wp_customize->add_setting( 'inspiry_shop_banner_separator', array(
			'sanitize_callback' => 'inspiry_sanitize',
		) );
		$wp_customize->add_control(
			new Inspiry_Separator_Control(
				$wp_customize,
				'inspiry_shop_banner_separator',
				array(
					'section' => 'inspiry_shop_section',
				)
			)
		);

		$wp_customize->add_setting( 'inspiry_shop_banner_title', array(
			'default'           => esc_html__( 'Shop', 'inspiry-tourpress' ),
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'inspiry_shop_banner_title', array(
			'label'       => esc_html__( 'Shop Banner Title', 'inspiry-tourpress' ),
			'type'        => 'text',
			'section'     => 'inspiry_shop_section',
			'settings'    => 'inspiry_shop_banner_title',
			'description' => esc_html__( "Default shop page title will be 'Shop' if you leave this field empty.", 'inspiry-tourpress' )
		) );

		$wp_customize->add_setting( 'inspiry_shop_products_per_page', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'inspiry_shop_products_per_page', array(
			'label'       => esc_html__( "Shop's Products Per Page", 'inspiry-tourpress' ),
			'type'        => 'text',
			'section'     => 'inspiry_shop_section',
			'settings'    => 'inspiry_shop_products_per_page',
			'description' => esc_html__( 'If this field is empty, Default (Admin > Settings > reading ) blog posts per page number will be applied.', 'inspiry-tourpress' )
		) );


	}

	add_action( 'customize_register', 'inspiry_shop_customizer' );

}