<?php
/**
 * Customizer settings for Tour Search page
 */

if ( ! function_exists( 'inspiry_tour_search_customizer' ) ) :
	function inspiry_tour_search_customizer( WP_Customize_Manager $wp_customize ) {

		/**
		 * Tour Search Section
		 */
		$wp_customize->add_section( 'inspiry_tour_search_section', array(
			'title'    => esc_html__( 'Tour Search Page', 'inspiry-tourpress' ),
			'priority' => 185
		) );

		// build array of pages
		$inspiry_pages = array( 0 => esc_html__( 'None', 'inspiry-tourpress' ) );
		$obj_pages     = get_pages();
		if ( count( $obj_pages ) > 0 ) {
			foreach ( $obj_pages as $page ) {
				$inspiry_pages[ $page->ID ] = $page->post_title;
			}
		}

		// tours search page
		$wp_customize->add_setting( 'inspiry_search_page', array(
				'sanitize_callback' => 'inspiry_sanitize'
			)
		);
		$wp_customize->add_control( new Inspiry_Dropdown_Control(
			$wp_customize,
			'inspiry_search_page',
			array(
				'label'       => esc_html__( 'Tours Search Results Page', 'inspiry-tourpress' ),
				'description' => esc_html__( 'Choose, tours search results page. You can create search results page by using "Tours Search" template if you haven\'t created one yet. For more details please consult the theme documentation.', 'inspiry-tourpress' ),
				'settings'    => 'inspiry_search_page',
				'section'     => 'inspiry_tour_search_section',
				'choices'     => $inspiry_pages
			)
		) );

		// tours search page
		$wp_customize->add_setting( 'inspiry_search_tours_per_page', array(
			'default'           => '6',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'inspiry_search_tours_per_page', array(
			'label'       =>  esc_html__( 'Number of Tours Per Page', 'inspiry-tourpress' ),
			'settings'    => 'inspiry_search_tours_per_page',
			'section'     => 'inspiry_tour_search_section',
			'type'        => 'text'
		) );
	}

	if ( shortcode_exists( 'inspiry_tour_search_form' ) ) {
		add_action( 'customize_register', 'inspiry_tour_search_customizer' );
	}
endif;