<?php
/**
 * Customizer settings for Tour Detail
 */

if ( ! function_exists( 'inspiry_tour_detail_customizer' ) ) :
	function inspiry_tour_detail_customizer( WP_Customize_Manager $wp_customize ) {

		/**
		 * Tour Detail Section
		 */
		$wp_customize->add_section( 'inspiry_tour_detail_section', array(
			'title'    => esc_html__( 'Tour Detail Page', 'inspiry-tourpress' ),
			'priority' => 180
		) );

		// booking form display
		$wp_customize->add_setting( 'inspiry_booking_form', array(
			'default'           => 'show',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( new Inspiry_Dropdown_Control(
			$wp_customize,
			'inspiry_booking_form',
			array(
				'label'    => esc_html__( 'Booking Form in Sidebar', 'inspiry-tourpress' ),
				'section'  => 'inspiry_tour_detail_section',
				'settings' => 'inspiry_booking_form',
				'choices'  => array(
					'show' => esc_html__( 'Show', 'inspiry-tourpress' ),
					'hide' => esc_html__( 'Hide', 'inspiry-tourpress' ),
				)
			)
		) );

		// Registers booking widget background settings
		$wp_customize->add_setting( 'inspiry_tb_background_image_url', array(
			'sanitize_callback' => 'esc_url',
		) );

		$wp_customize->add_setting( 'inspiry_tb_background_image_id', array(
			'sanitize_callback' => 'absint'
		) );

		$wp_customize->add_setting( 'inspiry_tb_background_repeat', array(
			'default'           => 'no-repeat',
			'sanitize_callback' => 'sanitize_text_field'
		) );

		$wp_customize->add_setting( 'inspiry_tb_background_size', array(
			'default'           => 'auto',
			'sanitize_callback' => 'sanitize_text_field'
		) );

		$wp_customize->add_setting( 'inspiry_tb_background_position', array(
			'default'           => 'center-center',
			'sanitize_callback' => 'sanitize_text_field'
		) );

		// Registers inspiry_tb_background control
		$wp_customize->add_control(
			new Customize_Custom_Background_Control(
				$wp_customize,
				'inspiry_tb_background',
				array(
					'label'    => esc_html__( 'Booking Form Cover Photo', 'inspiry-tourpress' ),
					'section'  => 'inspiry_tour_detail_section',
					'settings' => array(
						'image_url' => 'inspiry_tb_background_image_url',
						'image_id'  => 'inspiry_tb_background_image_id',
						'repeat'    => 'inspiry_tb_background_repeat', // Use false to hide the field
						'size'      => 'inspiry_tb_background_size',
						'position'  => 'inspiry_tb_background_position'
					),
					'active_callback' => 'inspiry_booking_form'
				)
			)
		);

		// booking form target email
		$wp_customize->add_setting( 'inspiry_booking_form_title', array(
			'default'           => esc_html__( 'Book the tour', 'inspiry-tourpress' ),
			'sanitize_callback' => 'sanitize_text_field',

		) );

		$wp_customize->add_control( 'inspiry_booking_form_title', array(
			'label'       => esc_html__( 'Booking Form Title', 'inspiry-tourpress' ),
			'section'     => 'inspiry_tour_detail_section',
			'settings'    => 'inspiry_booking_form_title',
			'type'        => 'text',
			'active_callback' => 'inspiry_booking_form'
		) );


		// booking form target email
		$wp_customize->add_setting( 'inspiry_booking_form_email', array(
			'default'           => get_bloginfo( 'admin_email' ),
			'sanitize_callback' => 'sanitize_text_field',

		) );

		$wp_customize->add_control( 'inspiry_booking_form_email', array(
			'label'       => esc_html__( 'Booking Form Email', 'inspiry-tourpress' ),
			'description' => esc_html__( 'Please provide an email address where you would like to receive the tour booking form requests.', 'inspiry-tourpress' ),
			'section'     => 'inspiry_tour_detail_section',
			'settings'    => 'inspiry_booking_form_email',
			'type'        => 'text',
			'active_callback' => 'inspiry_booking_form'
		) );

		// separator
		$wp_customize->add_setting( 'inspiry_tour_reviews_separator', array(
			'sanitize_callback' => 'inspiry_sanitize',
		) );
		$wp_customize->add_control(
			new Inspiry_Separator_Control(
				$wp_customize,
				'inspiry_tour_reviews_separator',
				array(
					'section' => 'inspiry_tour_detail_section',
				)
			)
		);

		// tours reviews display
		$wp_customize->add_setting( 'inspiry_tours_reviews', array(
			'default'           => 'show',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( new Inspiry_Dropdown_Control(
			$wp_customize,
			'inspiry_tours_reviews',
			array(
				'label'    => esc_html__( 'Tours Reviews', 'inspiry-tourpress' ),
				'section'  => 'inspiry_tour_detail_section',
				'settings' => 'inspiry_tours_reviews',
				'choices'  => array(
					'show' => esc_html__( 'Show', 'inspiry-tourpress' ),
					'hide' => esc_html__( 'Hide', 'inspiry-tourpress' ),
				)
			)
		) );

		// tour reviews title
		$wp_customize->add_setting( 'inspiry_tour_reviews_title', array(
			'default'           => esc_html__( 'Tours Reviews', 'inspiry-tourpress' ),
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'inspiry_tour_reviews_title', array(
			'label'           => esc_html__( 'Tour Reviews Title', 'inspiry-tourpress' ),
			'section'         => 'inspiry_tour_detail_section',
			'settings'        => 'inspiry_tour_reviews_title',
			'type'            => 'text',
			'active_callback' => 'inspiry_tours_reviews'
		) );


		// tour reviews description
		$wp_customize->add_setting( 'inspiry_tour_reviews_description', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'inspiry_tour_reviews_description', array(
			'label'           => esc_html__( 'Tour Reviews Description', 'inspiry-tourpress' ),
			'section'         => 'inspiry_tour_detail_section',
			'settings'        => 'inspiry_tour_reviews_description',
			'type'            => 'textarea',
			'active_callback' => 'inspiry_tours_reviews'
		) );

		// separator
		$wp_customize->add_setting( 'inspiry_similar_tours_separator', array(
			'sanitize_callback' => 'inspiry_sanitize',
		) );
		$wp_customize->add_control(
			new Inspiry_Separator_Control(
				$wp_customize,
				'inspiry_similar_tours_separator',
				array(
					'section' => 'inspiry_tour_detail_section',
				)
			)
		);

		// similar tours display
		$wp_customize->add_setting( 'inspiry_similar_tours', array(
			'default'           => 'show',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( new Inspiry_Dropdown_Control(
			$wp_customize,
			'inspiry_similar_tours',
			array(
				'label'    => esc_html__( 'Similar Tours', 'inspiry-tourpress' ),
				'section'  => 'inspiry_tour_detail_section',
				'settings' => 'inspiry_similar_tours',
				'choices'  => array(
					'show' => esc_html__( 'Show', 'inspiry-tourpress' ),
					'hide' => esc_html__( 'Hide', 'inspiry-tourpress' ),
				)
			)
		) );

		// similar tours title
		$wp_customize->add_setting( 'inspiry_similar_tours_title', array(
			'default'           => esc_html__( 'Similar Tours', 'inspiry-tourpress' ),
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'inspiry_similar_tours_title', array(
			'label'           => esc_html__( 'Similar Tours Title', 'inspiry-tourpress' ),
			'section'         => 'inspiry_tour_detail_section',
			'settings'        => 'inspiry_similar_tours_title',
			'type'            => 'text',
			'active_callback' => 'inspiry_similar_tours'
		) );


		// similar tours description
		$wp_customize->add_setting( 'inspiry_similar_tours_description', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'inspiry_similar_tours_description', array(
			'label'           => esc_html__( 'Similar Tours Description', 'inspiry-tourpress' ),
			'section'         => 'inspiry_tour_detail_section',
			'settings'        => 'inspiry_similar_tours_description',
			'type'            => 'textarea',
			'active_callback' => 'inspiry_similar_tours'
		) );
	}

	add_action( 'customize_register', 'inspiry_tour_detail_customizer' );
endif;

if ( ! function_exists( 'inspiry_booking_form' ) ) :
	/**
	 * Check booking tours form display
	 * @return bool
	 */
	function inspiry_booking_form( $control ) {

		$booking_form = $control->manager->get_setting( 'inspiry_booking_form' )->value();

		if ( 'hide' == $booking_form ) {
			return false;
		}

		return true;
	}
endif;

if ( ! function_exists( 'inspiry_tours_reviews' ) ) :
	/**
	 * Check tours reviews display
	 * @return bool
	 */
	function inspiry_tours_reviews( $control ) {

		$tours_reviews = $control->manager->get_setting( 'inspiry_tours_reviews' )->value();

		if ( 'hide' == $tours_reviews ) {
			return false;
		}

		return true;
	}
endif;

if ( ! function_exists( 'inspiry_similar_tours' ) ) :
	/**
	 * Check similar tours display
	 * @return bool
	 */
	function inspiry_similar_tours( $control ) {

		$similar_tours = $control->manager->get_setting( 'inspiry_similar_tours' )->value();

		if ( 'hide' == $similar_tours ) {
			return false;
		}

		return true;
	}
endif;