<?php
/**
 * Customizer settings for Taxonomy & Archive Pages
 */

if ( ! function_exists( 'inspiry_tax_archive_section' ) ) :

	function inspiry_tax_archive_section( WP_Customize_Manager $wp_customize ) {

		/**
		 * Taxonomy & Archive Pages Section
		 */

		// Layout for taxonomy and archive pages
		$wp_customize->add_setting( 'inspiry_tax_archive_layout', array(
			'default'           => 'grid',
			'sanitize_callback' => 'inspiry_sanitize',
		) );

		$wp_customize->add_control( 'inspiry_tax_archive_layout', array(
			'label'           => esc_html__( 'Select Layout', 'inspiry-tourpress' ),
			'type'            => 'select',
			'section'         => 'inspiry_tax_archive_section',
			'choices'         => array(
				'grid' => 'Grid Layout',
				'list' => 'List Layout',
			),
		) );

		// Sticky Header
		$wp_customize->add_setting( 'inspiry_tax_archive_sidebar', array(
			'default'           => 'disable',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'inspiry_tax_archive_sidebar', array(
			'label'    => esc_html__( 'Sidebar', 'inspiry-tourpress' ),
			'section'  => 'inspiry_tax_archive_section',
			'settings' => 'inspiry_tax_archive_sidebar',
			'type'     => 'radio',
			'choices'  => array(
				'enable'  => esc_html__( 'Enable', 'inspiry-tourpress' ),
				'disable' => esc_html__( 'Disable', 'inspiry-tourpress' ),
			)
		) );

		$wp_customize->add_section( 'inspiry_tax_archive_section', array(
			'title'    => esc_html__( 'Taxonomy & Archives Pages', 'inspiry-tourpress' ),
			'priority' => 190
		) );

		// number of tours on taxonomy and archive pages
		$wp_customize->add_setting( 'inspiry_tax_archive_tours', array(
			'default'           => '5',
			'sanitize_callback' => 'inspiry_sanitize',
		) );

		$wp_customize->add_control( 'inspiry_tax_archive_tours', array(
			'label'           => esc_html__( 'Number Of Tours To Display', 'inspiry-tourpress' ),
			'type'            => 'select',
			'section'         => 'inspiry_tax_archive_section',
			'choices'         => array( 
				1 => 1,
				2 => 2,
				3 => 3,
				4 => 4,
				5 => 5,
				6 => 6,
				7 => 7,
				8 => 8,
				9 => 9,
				10 => 10,
				11 => 11,
				12 => 12,
				13 => 13,
				14 => 14,
				15 => 15,
				16 => 16,
				17 => 17,
				18 => 18,
				19 => 19,
				20 => 20
			),
		) );

	}

	add_action( 'customize_register', 'inspiry_tax_archive_section' );
endif;