<?php
if ( ! function_exists( 'inspiry_header_styles_customizer' ) ) {
	function inspiry_header_styles_customizer( WP_Customize_Manager $wp_customize ) {

		/**
		 * Header Section
		 */
		$wp_customize->add_section( 'inspiry_header_styles', array(
			'title' => __( 'Header Styles', 'inspiry-tourpress' ),
			'panel' => 'inspiry_styles_panel',
		) );


		// Header Top Bar
		$wp_customize->add_setting( 'inspiry_top_bar_bg_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_top_bar_bg_color', array(
				'label'       => __( 'Top Bar Background Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_header_styles'
			) ) );

		$wp_customize->add_setting( 'inspiry_top_bar_text_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_top_bar_text_color', array(
				'label'       => __( 'Top Bar Text Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_header_styles'
			) ) );

		$wp_customize->add_setting( 'inspiry_top_bar_text_hover_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_top_bar_text_hover_color', array(
				'label'       => __( 'Top Bar Text Hover Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_header_styles'
			) ) );

		$wp_customize->add_setting( 'inspiry_top_bar_cart_bg_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_top_bar_cart_bg_color', array(
				'label'       => __( 'Top Bar Cart Button Background Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_header_styles'
			) ) );

		$wp_customize->add_setting( 'inspiry_top_bar_cart_active_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_top_bar_cart_active_color', array(
				'label'       => __( 'Top Bar Cart Button Active Dot Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_header_styles'
			) ) );


		// separator
		$wp_customize->add_setting( 'inspiry_header_styles_separator_1', array(
			'sanitize_callback' => 'inspiry_sanitize',
		) );
		$wp_customize->add_control(
			new Inspiry_Separator_Control( $wp_customize, 'inspiry_header_styles_separator_1', array(
					'section' => 'inspiry_header_styles',
			) ) );

		// Header
		$wp_customize->add_setting( 'inspiry_header_text_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_header_text_color', array(
				'label'       => __( 'Header Text Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_header_styles'
			) ) );

		$wp_customize->add_setting( 'inspiry_header_text_hover_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_header_text_hover_color', array(
				'label'       => __( 'Header Text Hover Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_header_styles'
			) ) );

		$wp_customize->add_setting( 'inspiry_header_bg_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_header_bg_color', array(
				'label'       => __( 'Header Background Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_header_styles'
			) ) );

		// separator
		$wp_customize->add_setting( 'inspiry_header_styles_separator_2', array(
			'sanitize_callback' => 'inspiry_sanitize',
		) );
		$wp_customize->add_control(
			new Inspiry_Separator_Control( $wp_customize, 'inspiry_header_styles_separator_2', array(
				'section' => 'inspiry_header_styles',
			) ) );

		// Main Menu
		$wp_customize->add_setting( 'inspiry_main_menu_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_main_menu_color', array(
				'label'       => __( 'Main Menu Text Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_header_styles'
			) ) );

		$wp_customize->add_setting( 'inspiry_main_menu_hover_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_main_menu_hover_color', array(
				'label'       => __( 'Main Menu Text Hover Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_header_styles'
			) ) );

		$wp_customize->add_setting( 'inspiry_sub_menu_bg_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_sub_menu_bg_color', array(
				'label'       => __( 'Sub Menu Background Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_header_styles'
			) ) );

		$wp_customize->add_setting( 'inspiry_sub_menu_text_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_sub_menu_text_color', array(
				'label'       => __( 'Sub Menu Text Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_header_styles'
			) ) );

		$wp_customize->add_setting( 'inspiry_sub_menu_bg_hover_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_sub_menu_bg_hover_color', array(
				'label'       => __( 'Sub Menu Background Hover Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_header_styles'
			) ) );

		$wp_customize->add_setting( 'inspiry_sub_menu_text_hover_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_sub_menu_text_hover_color', array(
				'label'       => __( 'Sub Menu Text Hover Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_header_styles'
			) ) );

		$wp_customize->add_setting( 'inspiry_sub_menu_item_border_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_sub_menu_item_border_color', array(
				'label'       => __( 'Sub Menu Item Border Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_header_styles'
			) ) );

		// separator
		$wp_customize->add_setting( 'inspiry_header_styles_separator_3', array(
			'sanitize_callback' => 'inspiry_sanitize',
		) );
		$wp_customize->add_control(
			new Inspiry_Separator_Control( $wp_customize, 'inspiry_header_styles_separator_3', array(
				'section' => 'inspiry_header_styles',
			) ) );

		// Phone Number
		$wp_customize->add_setting( 'inspiry_header_phone_number_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_header_phone_number_color', array(
				'label'       => __( 'Header Phone Number Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_header_styles'
			) ) );

		// separator
		$wp_customize->add_setting( 'inspiry_header_styles_separator_4', array(
			'sanitize_callback' => 'inspiry_sanitize',
		) );
		$wp_customize->add_control(
			new Inspiry_Separator_Control( $wp_customize, 'inspiry_header_styles_separator_4', array(
				'section' => 'inspiry_header_styles',
			) ) );

		// Mobile Menu
		$wp_customize->add_setting( 'inspiry_mobile_menu_bg_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_mobile_menu_bg_color', array(
				'label'       => __( 'Mobile Menu Background Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_header_styles'
			) ) );

		$wp_customize->add_setting( 'inspiry_mobile_menu_text_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_mobile_menu_text_color', array(
				'label'       => __( 'Mobile Menu Text Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_header_styles'
			) ) );

		$wp_customize->add_setting( 'inspiry_mobile_menu_expand_button_bg_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_mobile_menu_expand_button_bg_color', array(
				'label'       => __( 'Mobile Sub Menu Expand Button Background Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_header_styles'
			) ) );

		$wp_customize->add_setting( 'inspiry_mobile_menu_expand_button_bg_hover_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_mobile_menu_expand_button_bg_hover_color', array(
				'label'       => __( 'Mobile Sub Menu Expand Button Background Hover Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_header_styles'
			) ) );
	}

	add_action( 'customize_register', 'inspiry_header_styles_customizer' );
}