<?php
if ( ! function_exists( 'inspiry_footer_styles_customizer' ) ) {
	function inspiry_footer_styles_customizer( WP_Customize_Manager $wp_customize ) {

		/**
		 * Footer Section
		 */
		$wp_customize->add_section( 'inspiry_footer_styles', array(
			'title' => __( 'Footer Styles', 'inspiry-tourpress' ),
			'panel' => 'inspiry_styles_panel',
		) );


		$wp_customize->add_setting( 'inspiry_footer_bg_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_footer_bg_color', array(
				'label'       => __( 'Footer Background Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_footer_styles'
			) ) );

		$wp_customize->add_setting( 'inspiry_footer_text_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_footer_text_color', array(
				'label'       => __( 'Footer Text Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_footer_styles'
			) ) );

		$wp_customize->add_setting( 'inspiry_footer_link_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_footer_link_color', array(
				'label'       => __( 'Footer Link Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_footer_styles'
			) ) );

		$wp_customize->add_setting( 'inspiry_footer_link_hover_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_footer_link_hover_color', array(
				'label'       => __( 'Footer Link Hover Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_footer_styles'
			) ) );

		$wp_customize->add_setting( 'inspiry_footer_widget_title_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_footer_widget_title_color', array(
				'label'       => __( 'Footer Widget Title Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_footer_styles'
			) ) );

		$wp_customize->add_setting( 'inspiry_footer_bottom_top_border_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_footer_bottom_top_border_color', array(
				'label'       => __( 'Footer Bottom Top Border Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_footer_styles'
			) ) );

	}

	add_action( 'customize_register', 'inspiry_footer_styles_customizer' );
}