<?php
if ( ! function_exists( 'inspiry_core_styles_customizer' ) ) {
	function inspiry_core_styles_customizer( WP_Customize_Manager $wp_customize ) {

		$wp_customize->add_section( 'inspiry_core_styles_section', array(
			'title' => esc_html__( 'Core Styles', 'inspiry-tourpress' ),
			'panel' => 'inspiry_styles_panel',
		) );

		$wp_customize->add_setting( 'inspiry_body_text_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_body_text_color', array(
				'label'       => __( 'Text Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_core_styles_section'
			) ) );

		$wp_customize->add_setting( 'inspiry_heading_text_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_heading_text_color', array(
				'label'       => __( 'Heading Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_core_styles_section'
			) ) );

		$wp_customize->add_setting( 'inspiry_link_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_link_color', array(
				'label'       => __( 'Link Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_core_styles_section'
			) ) );

		$wp_customize->add_setting( 'inspiry_link_hover_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_link_hover_color', array(
				'label'       => __( 'Link Hover Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_core_styles_section'
			) ) );

		$wp_customize->add_setting( 'inspiry_primary_bg_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_primary_bg_color', array(
				'label'       => __( 'Primary Background Color', 'inspiry-tourpress' ),
				'description' => sprintf( esc_html__( 'These color options replace the Background and Text color of %1$s
														• Overall Theme Buttons %1$s
														• Tour Detail Page Icons and Tabs %1$s
														• Shop, Cart, Account and Checkout pages %1$s
														• Post Tags %1$s
														• Pagination', 'inspiry-tourpress' ),"<br>"),
				'section'     => 'inspiry_core_styles_section'
			) ) );

		$wp_customize->add_setting( 'inspiry_primary_text_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_primary_text_color', array(
				'label'       => __( 'Primary Text Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_core_styles_section'
			) ) );

		$wp_customize->add_setting( 'inspiry_primary_bg_hover_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_primary_bg_hover_color', array(
				'label'       => __( 'Primary Background Hover Color', 'inspiry-tourpress' ),
				'description' => sprintf( esc_html__( 'These color options replace the Background and Text hover color of %1$s
														• Overall Theme Buttons %1$s
														• Tour Cards Labels and Badges %1$s
														• Tour Detail Page Tabs %1$s
														• Shop, Cart, Account and Checkout pages %1$s
														• Post Tags %1$s
														• Pagination', 'inspiry-tourpress' ),"<br>"),
				'section'     => 'inspiry_core_styles_section'
			) ) );

		$wp_customize->add_setting( 'inspiry_primary_text_hover_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_primary_text_hover_color', array(
				'label'       => __( 'Primary Text Hover Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_core_styles_section'
			) ) );

		$wp_customize->add_setting( 'inspiry_secondary_bg_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_secondary_bg_color', array(
				'label'       => __( 'Secondary Color', 'inspiry-tourpress' ),
				'description' => sprintf( esc_html__( 'This color option replaces the color of %1$s
														• Slider Button %1$s
														• Search Form Icons %1$s
														• Start Ratings', 'inspiry-tourpress' ),"<br>"),
				'section'     => 'inspiry_core_styles_section'
			) ) );

	}

	add_action( 'customize_register', 'inspiry_core_styles_customizer' );
}