<?php
if ( ! function_exists( 'inspiry_banner_styles_customizer' ) ) {
	function inspiry_banner_styles_customizer( WP_Customize_Manager $wp_customize ) {

		/**
		 * Banner Section
		 */
		$wp_customize->add_section( 'inspiry_banner_styles', array(
			'title' => __( 'Banner Styles', 'inspiry-tourpress' ),
			'panel' => 'inspiry_styles_panel',
		) );


		$wp_customize->add_setting( 'inspiry_banner_bg_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_banner_bg_color', array(
				'label'       => __( 'Banner Background Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_banner_styles'
			) ) );

		$wp_customize->add_setting( 'inspiry_banner_text_color', array(
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'inspiry_banner_text_color', array(
				'label'       => __( 'Banner Text Color', 'inspiry-tourpress' ),
				'section'     => 'inspiry_banner_styles'
			) ) );

	}

	add_action( 'customize_register', 'inspiry_banner_styles_customizer' );
}