<?php
/**
 * Styles Settings
 */
if ( ! function_exists( 'inspiry_styles_customizer' ) ) {
	function inspiry_styles_customizer( WP_Customize_Manager $wp_customize ) {

		/**
		 * Styles Panel
		 */
		$wp_customize->add_panel( 'inspiry_styles_panel', array(
			'title'    => esc_html__( 'Styles', 'inspiry-tourpress' ),
			'priority' => 40,
		) );

		/**
		 * Colors Type Section
		 */
		$wp_customize->add_section( 'inspiry_default_or_custom_section', array(
			'title' => esc_html__( 'Default or Custom', 'inspiry-tourpress' ),
			'panel' => 'inspiry_styles_panel',
		) );
		
		$wp_customize->add_setting( 'inspiry_default_styles', array(
			'default' => 'default',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'inspiry_default_styles', array(
			'label'       => esc_html__( 'Chose your preferred theme colors.', 'inspiry-tourpress' ),
			'section'     => 'inspiry_default_or_custom_section',
			'type'        => 'radio',
			'settings'    => 'inspiry_default_styles',
			'choices'     => array(
				'default' => esc_html__( 'Default Theme Colors', 'inspiry-tourpress' ),
				'custom'  => esc_html__( 'Custom Theme Colors', 'inspiry-tourpress' ),
			),
		) );
	}

	add_action( 'customize_register', 'inspiry_styles_customizer' );
}

/**
 * Core Styles
 */
require_once( INSPIRY_INC_DIRECTORY . 'customizer/theme-settings/styles/core-styles.php' );

/**
 * Header Styles
 */
require_once( INSPIRY_INC_DIRECTORY . 'customizer/theme-settings/styles/header-styles.php' );

/**
 * Banner Styles
 */
require_once( INSPIRY_INC_DIRECTORY . 'customizer/theme-settings/styles/banner-styles.php' );

/**
 * Footer Styles
 */
require_once( INSPIRY_INC_DIRECTORY . 'customizer/theme-settings/styles/footer-styles.php' );