<?php
/**
 * Customizer settings for Miscellaneous
 */

if ( ! function_exists( 'inspiry_misc_customizer' ) ) :
	function inspiry_misc_customizer( WP_Customize_Manager $wp_customize ) {

		/**
		 * Misc Section
		 */
		$wp_customize->add_section( 'inspiry_misc_section', array(
			'title'    => esc_html__( 'Misc', 'inspiry-tourpress' ),
			'priority' => 190
		) );

		// site pre-loading screen display
		$wp_customize->add_setting( 'inspiry_site_loader_display', array(
			'default'           => 'hide',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( new Inspiry_Dropdown_Control(
			$wp_customize,
			'inspiry_site_loader_display',
			array(
				'label'    => esc_html__( 'Site Preloading Screen', 'inspiry-tourpress' ),
				'section'  => 'inspiry_misc_section',
				'settings' => 'inspiry_site_loader_display',
				'choices'  => array(
					'show' => 'Enable',
					'hide' => 'Disable',
				),
			)
		) );

		// loader type
		$wp_customize->add_setting( 'inspiry_site_loader_type', array(
			'default'           => 'spinner1',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( new Inspiry_Dropdown_Control(
			$wp_customize,
			'inspiry_site_loader_type',
			array(
				'label'    => esc_html__( 'Screen Style', 'inspiry-tourpress' ),
				'section'  => 'inspiry_misc_section',
				'settings' => 'inspiry_site_loader_type',
				'choices'  => array(
					'spinner1' => esc_html__( 'First', 'inspiry-tourpress' ),
					'spinner2' => esc_html__( 'Second', 'inspiry-tourpress' ),
					'spinner3' => esc_html__( 'Third', 'inspiry-tourpress' ),
					'spinner4' => esc_html__( 'Fourth', 'inspiry-tourpress' ),
					'spinner5' => esc_html__( 'Fifth', 'inspiry-tourpress' ),
					'spinner6' => esc_html__( 'Sixth', 'inspiry-tourpress' ),
					'spinner7' => esc_html__( 'Seventh', 'inspiry-tourpress' ),
				),
			)
		) );

		// loader background color
		$wp_customize->add_setting( 'inspiry_site_loader_background', array(
			'default'           => '#004274',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'inspiry_site_loader_background',
				array(
					'label'    => esc_html__( 'Screen Background Color', 'inspiry-tourpress' ),
					'section'  => 'inspiry_misc_section',
					'settings' => 'inspiry_site_loader_background',
				)
			)
		);

		/* Separator */
		$wp_customize->add_setting( 'inspiry_site_loader_display_separator', array(
			'sanitize_callback' => 'inspiry_sanitize',
		) );
		$wp_customize->add_control(
			new Inspiry_Separator_Control(
				$wp_customize,
				'inspiry_site_loader_display_separator',
				array(
					'section'  => 'inspiry_misc_section',
				)
			)
		);
	}

	add_action( 'customize_register', 'inspiry_misc_customizer' );
endif;