<?php
/**
 * Customizer settings for Home Travel Destinations
 */

if ( ! function_exists( 'inspiry_home_travel_destinations' ) ) :
	function inspiry_home_travel_destinations( WP_Customize_Manager $wp_customize ) {

		/**
		 * Features Panel
		 */
		$wp_customize->add_section( 'inspiry_home_travel_destinations', array(
			'title'    => esc_html__( 'Travel Destinations', 'inspiry-tourpress' ),
			'panel'    => 'inspiry_home_panel',
			'priority' => 160
		) );

		// features title
		$wp_customize->add_setting( 'inspiry_travel_destinations_title', array(
			'default'           => esc_html__( 'Travel Destinations', 'inspiry-tourpress' ),
			'sanitize_callback' => 'sanitize_text_field'
		) );

		$wp_customize->add_control( 'inspiry_travel_destinations_title', array(
			'label'    => esc_html__( 'Title', 'inspiry-tourpress' ),
			'section'  => 'inspiry_home_travel_destinations',
			'settings' => 'inspiry_travel_destinations_title',
			'type'     => 'text'
		) );

		// features description
		$wp_customize->add_setting( 'inspiry_travel_destinations_description', array(
			'sanitize_callback' => 'wp_kses_post'
		) );

		$wp_customize->add_control( 'inspiry_travel_destinations_description', array(
			'label'    => esc_html__( 'Description', 'inspiry-tourpress' ),
			'section'  => 'inspiry_home_travel_destinations',
			'settings' => 'inspiry_travel_destinations_description',
			'type'     => 'textarea'
		) );

		// number of destinations
		$wp_customize->add_setting( 'inspiry_travel_destinations_num', array(
			'default'           => 8,
			'sanitize_callback' => 'inspiry_sanitize'
		) );

		$wp_customize->add_control( new Inspiry_Dropdown_Control(
			$wp_customize,
			'inspiry_travel_destinations_num',
			array(
				'label'       => esc_html__( 'Number of Destinations', 'inspiry-tourpress' ),
				'description' => esc_html__( 'Select a number of destinations you want to display.', 'inspiry-tourpress' ),
				'section'     => 'inspiry_home_travel_destinations',
				'settings'    => 'inspiry_travel_destinations_num',
				'choices'     => array(
					4   => esc_html__( '4', 'inspiry-tourpress' ),
					8   => esc_html__( '8', 'inspiry-tourpress' ),
					12  => esc_html__( '12', 'inspiry-tourpress' ),
					100 => esc_html__( 'All', 'inspiry-tourpress' ),
				)
			)
		) );
	}

	add_action( 'customize_register', 'inspiry_home_travel_destinations' );
endif;
