<?php
/**
 * Customizer settings for Home Testimonials
 */

if ( ! function_exists( 'inspiry_home_testimonials' ) ) :
	function inspiry_home_testimonials( WP_Customize_Manager $wp_customize ) {

		/**
		 * Testimonials Panel
		 */
		$wp_customize->add_section( 'inspiry_home_testimonials', array(
			'title'    => esc_html__( 'Testimonials', 'inspiry-tourpress' ),
			'panel'    => 'inspiry_home_panel',
			'priority' => 160
		) );

		// testimonials title
		$wp_customize->add_setting( 'inspiry_testimonials_title', array(
			'default'           => esc_html__( 'Kind words from our Customers', 'inspiry-tourpress' ),
			'sanitize_callback' => 'sanitize_text_field'
		) );

		$wp_customize->add_control( 'inspiry_testimonials_title', array(
			'label'    => esc_html__( 'Title', 'inspiry-tourpress' ),
			'section'  => 'inspiry_home_testimonials',
			'settings' => 'inspiry_testimonials_title',
			'type'     => 'text'
		) );

		// testimonials description
		$wp_customize->add_setting( 'inspiry_testimonials_description', array(
			'sanitize_callback' => 'wp_kses_post'
		) );

		$wp_customize->add_control( 'inspiry_testimonials_description', array(
			'label'    => esc_html__( 'Description', 'inspiry-tourpress' ),
			'section'  => 'inspiry_home_testimonials',
			'settings' => 'inspiry_testimonials_description',
			'type'     => 'textarea'
		) );

		// number of testimonial posts
		$wp_customize->add_setting( 'inspiry_testimonials_posts', array(
			'default'           => 2,
			'sanitize_callback' => 'inspiry_sanitize'
		) );

		$wp_customize->add_control(
			new Inspiry_Dropdown_Control(
				$wp_customize,
				'sidebar_position_control',
				array(
					'label'       => esc_html__( 'Number of Testimonial Posts', 'inspiry-tourpress' ),
					'description' => esc_html__( 'Select a number of testimonial posts you want to display.', 'inspiry-tourpress' ),
					'section'     => 'inspiry_home_testimonials',
					'settings'    => 'inspiry_testimonials_posts',
					'choices'     => array(
						2   => esc_html__( '2', 'inspiry-tourpress' ),
						4   => esc_html__( '4', 'inspiry-tourpress' ),
						6   => esc_html__( '6', 'inspiry-tourpress' ),
						8   => esc_html__( '8', 'inspiry-tourpress' ),
						- 1 => esc_html__( 'All', 'inspiry-tourpress' ),
					)
				)
			)
		);

	}

	add_action( 'customize_register', 'inspiry_home_testimonials' );
endif;