<?php
/**
 * Customizer settings for Home Special Offers
 */

if ( ! function_exists( 'inspiry_home_special_offers' ) ) :
	function inspiry_home_special_offers( WP_Customize_Manager $wp_customize ) {

		/**
		 * Features Panel
		 */
		$wp_customize->add_section( 'inspiry_home_special_offers', array(
			'title'    => esc_html__( 'Special Offers', 'inspiry-tourpress' ),
			'panel'    => 'inspiry_home_panel',
			'priority' => 160
		) );

		// features title
		$wp_customize->add_setting( 'inspiry_special_offers_title', array(
			'default'           => esc_html__( 'Special Offers', 'inspiry-tourpress' ),
			'sanitize_callback' => 'sanitize_text_field'
		) );

		$wp_customize->add_control( 'inspiry_special_offers_title', array(
			'label'    => esc_html__( 'Title', 'inspiry-tourpress' ),
			'section'  => 'inspiry_home_special_offers',
			'settings' => 'inspiry_special_offers_title',
			'type'     => 'text'
		) );

		// features description
		$wp_customize->add_setting( 'inspiry_special_offers_description', array(
			'sanitize_callback' => 'wp_kses_post'
		) );

		$wp_customize->add_control( 'inspiry_special_offers_description', array(
			'label'    => esc_html__( 'Description', 'inspiry-tourpress' ),
			'section'  => 'inspiry_home_special_offers',
			'settings' => 'inspiry_special_offers_description',
			'type'     => 'textarea'
		) );

		// number of special offers
		$wp_customize->add_setting( 'inspiry_special_offer_tours', array(
			'default'           => 6,
			'sanitize_callback' => 'inspiry_sanitize'
		) );

		$wp_customize->add_control(
			new Inspiry_Dropdown_Control(
				$wp_customize,
				'inspiry_special_offer_tours',
				array(
					'label'       => esc_html__( 'Number of Special Offers', 'inspiry-tourpress' ),
					'description' => esc_html__( 'Select a number of special offers you want to display.', 'inspiry-tourpress' ),
					'section'     => 'inspiry_home_special_offers',
					'settings'    => 'inspiry_special_offer_tours',
					'choices'     => array(
						2   => esc_html__( '2', 'inspiry-tourpress' ),
						4   => esc_html__( '4', 'inspiry-tourpress' ),
						6   => esc_html__( '6', 'inspiry-tourpress' ),
						8   => esc_html__( '8', 'inspiry-tourpress' ),
						- 1 => esc_html__( 'All', 'inspiry-tourpress' ),
					)
				)
			)
		);

	}

	add_action( 'customize_register', 'inspiry_home_special_offers' );
endif;
