<?php
/**
 * Customizer settings for Home Slider
 */

if ( ! function_exists( 'inspiry_home_slider' ) ) :
	function inspiry_home_slider( WP_Customize_Manager $wp_customize ) {

		/**
		 * Slider Section
		 */
		$wp_customize->add_section( 'inspiry_home_slider_section', array(
				'title'    => esc_html__( 'Slider Area', 'inspiry-tourpress' ),
				'panel'    => 'inspiry_home_panel',
				'priority' => 160
			)
		);

		// what to display on slider area
		$wp_customize->add_setting( 'inspiry_home_slider_display', array(
				'default'           => 'slider',
				'sanitize_callback' => 'inspiry_sanitize'
			)
		);
		$wp_customize->add_control( new Inspiry_Dropdown_Control(
			$wp_customize,
			'inspiry_home_slider_display',
			array(
				'label'       => esc_html__( 'What to Display', 'inspiry-tourpress' ),
				'description' => esc_html__( 'Choose, what do you want to display at the slider area.', 'inspiry-tourpress' ),
				'settings'    => 'inspiry_home_slider_display',
				'section'     => 'inspiry_home_slider_section',
				'choices'     => array(
					'banner'            => esc_html__( 'Banner', 'inspiry-tourpress' ),
					'slider'            => esc_html__( 'Default Slider', 'inspiry-tourpress' ),
					'slider-revolution' => esc_html__( 'Slider Revolution', 'inspiry-tourpress' ),
				)
			)
		) );

		$wp_customize->add_setting( 'inspiry_home_rs_alias', array(
			'sanitize_callback' => 'sanitize_text_field'
		) );
		$wp_customize->add_control( 'inspiry_home_rs_alias', array(
			'label'       => esc_html__( 'Slider Revolution Alias', 'inspiry-tourpress' ),
			'description' => esc_html__( 'If you want to display Slider Revolution then provide its alias here.', 'inspiry-tourpress' ),
			'section'     => 'inspiry_home_slider_section',
			'settings'    => 'inspiry_home_rs_alias',
			'type'        => 'text',
			'active_callback' => 'inspiry_home_slider_revolution'
		) );

		// number of slider slides
		$wp_customize->add_setting( 'inspiry_home_slider_slides', array(
			'default'           => '3',
			'sanitize_callback' => 'inspiry_sanitize',
		) );

		$wp_customize->add_control( 'inspiry_home_slider_slides', array(
			'label'           => esc_html__( 'Number Of Slides To Display', 'inspiry-tourpress' ),
			'type'            => 'select',
			'section'         => 'inspiry_home_slider_section',
			'choices'         => array(
				1,
				2,
				3,
				4,
				5,
				6,
				7,
				8,
				9,
				10
			),
			'active_callback' => 'inspiry_home_slider_display'
		) );

		// search form under homepage slider
		$wp_customize->add_setting( 'inspiry_slider_search', array(
			'default'           => '1',
			'sanitize_callback' => 'inspiry_sanitize'
		) );
		$wp_customize->add_control( 'inspiry_slider_search', array(
			'label'           => esc_html__( 'Search Form With Slider', 'inspiry-tourpress' ),
			'type'            => 'radio',
			'section'         => 'inspiry_home_slider_section',
			'choices'         => array(
				'1' => esc_html__( 'Show', 'inspiry-tourpress' ),
				'0' => esc_html__( 'Hide', 'inspiry-tourpress' ),
			),
			'active_callback' => 'inspiry_home_slider_display'
		) );

		// trapezoid under search form
		$wp_customize->add_setting( 'inspiry_slider_search_trapezoid', array(
			'default'           => '1',
			'sanitize_callback' => 'inspiry_sanitize'
		) );
		$wp_customize->add_control( 'inspiry_slider_search_trapezoid', array(
			'label'           => esc_html__( 'Trapezoid Under Search Form', 'inspiry-tourpress' ),
			'type'            => 'radio',
			'section'         => 'inspiry_home_slider_section',
			'choices'         => array(
				'1' => esc_html__( 'Show', 'inspiry-tourpress' ),
				'0' => esc_html__( 'Hide', 'inspiry-tourpress' ),
			),
			'active_callback' => 'inspiry_slider_search'
		) );
	}

	add_action( 'customize_register', 'inspiry_home_slider' );
endif;

if ( ! function_exists( 'inspiry_home_slider_display' ) ) {
	/**
	 * Check if slider is displayed on homepage.
	 *
	 * @param $control
	 *
	 * @return bool
	 */
	function inspiry_home_slider_display( $control ) {
		$slider_display = $control->manager->get_setting( 'inspiry_home_slider_display' )->value();
		if ( 'slider' == $slider_display ) {
			return true;
		}

		return false;
	}
}

if( ! function_exists('inspiry_home_slider_revolution') ) {
	/**
	 * Check if slider revolution is displayed on homepage
	 *
	 * @param $control
	 *
	 * @return bool
	 */
	function inspiry_home_slider_revolution( $control ) {
		if ( 'slider-revolution' === $control->manager->get_setting( 'inspiry_home_slider_display' )->value() ) {
			return true;
		} else {
			return false;
		}
	}
}

if( ! function_exists('inspiry_slider_search') ) {
	/**
	 * Check if search form displayed over slider
	 *
	 * @param $control
	 *
	 * @return bool
	 */
	function inspiry_slider_search( $control ) {
		if ( '1' === $control->manager->get_setting( 'inspiry_slider_search' )->value() ) {
			return true;
		} else {
			return false;
		}
	}
}