<?php
/**
 * Customizer settings for homepage sections manager
 */

if ( ! function_exists( 'inspiry_home_sections_manager' ) ) :
	function inspiry_home_sections_manager( WP_Customize_Manager $wp_customize ) {

		/**
		 * Sections Manager
		 */
		$wp_customize->add_section( 'inspiry_sections_manager', array(
			'title'    => esc_html__( 'Sections Manager', 'inspiry-tourpress' ),
			'panel'    => 'inspiry_home_panel',
			'priority' => 160
		) );

		// Home sections display
		$wp_customize->add_setting( 'inspiry_home_sections_display', array(
			'sanitize_callback' => 'inspiry_sanitize'
		) );

		$wp_customize->add_control( new Inspiry_Multiple_Checkbox_Customize_Control (
			$wp_customize,
			'inspiry_home_sections_display',
			array(
				'label'    => esc_html__( 'Sections Display', 'inspiry-tourpress' ),
				'settings' => 'inspiry_home_sections_display',
				'section'  => 'inspiry_sections_manager',
				'choices'  => array(
					'contents'             => esc_html__( 'Contents', 'inspiry-tourpress' ),
					'features'             => esc_html__( 'Features', 'inspiry-tourpress' ),
					'featured-packages'    => esc_html__( 'Featured Packages', 'inspiry-tourpress' ),
					'travel-destinations' => esc_html__( 'Travel Destinations', 'inspiry-tourpress' ),
					'special-offers'       => esc_html__( 'Special Offers', 'inspiry-tourpress' ),
					'mood-destinations'    => esc_html__( 'Destination By Mood', 'inspiry-tourpress' ),
					'blog'                 => esc_html__( 'Blog', 'inspiry-tourpress' ),
					'testimonials'         => esc_html__( 'Testimonials', 'inspiry-tourpress' ),
					'explore-tours'        => esc_html__( 'Explore Tours', 'inspiry-tourpress' )
				)
			)
		) );

		// Home sections order
		$wp_customize->add_setting( 'inspiry_home_sections_order', array(
			'default'           => 'contents,features,featured-packages,travel-destinations,special-offers,mood-destinations,blog,testimonials,explore-tours',
			'sanitize_callback' => 'inspiry_sanitize'
		) );

		$wp_customize->add_control( new Inspiry_Dragdrop_Control(
			$wp_customize,
			'inspiry_home_sections_order',
			array(
				'label'       => esc_html__( 'Sections Order', 'inspiry-tourpress' ),
				'description' => esc_html__( 'You can reorder the homepage sections here.', 'inspiry-tourpress' ),
				'settings'    => 'inspiry_home_sections_order',
				'section'     => 'inspiry_sections_manager',
				'choices'     => array(
					'contents'             => esc_html__( 'Contents', 'inspiry-tourpress' ),
					'features'             => esc_html__( 'Features', 'inspiry-tourpress' ),
					'featured-packages'    => esc_html__( 'Featured Packages', 'inspiry-tourpress' ),
					'travel-destinations' => esc_html__( 'Travel Destinations', 'inspiry-tourpress' ),
					'special-offers'       => esc_html__( 'Special Offers', 'inspiry-tourpress' ),
					'mood-destinations'    => esc_html__( 'Destination By Mood', 'inspiry-tourpress' ),
					'blog'                 => esc_html__( 'Blog', 'inspiry-tourpress' ),
					'testimonials'         => esc_html__( 'Testimonials', 'inspiry-tourpress' ),
					'explore-tours'        => esc_html__( 'Explore Tours', 'inspiry-tourpress' )
				)
			)
		) );
	}

	add_action( 'customize_register', 'inspiry_home_sections_manager' );
endif;
